% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected.R
\encoding{UTF-8}
\name{exp_F}
\alias{exp_F}
\title{Expected inbreeding coefficient}
\usage{
exp_F(Ne, t)
}
\arguments{
\item{Ne}{Effective population size}

\item{t}{Generation number}
}
\value{
The inbreeding coefficient
}
\description{
Estimates the expected inbreeding coefficient (F) as a function of the effective population size and generation number
}
\details{
Computation of the inbreeding coefficient uses the classical formula:

F(t) = 1 - (1 - 1/2N) ^ t
}
\examples{
exp_F(Ne = 50, t = 0)
exp_F(Ne = 50, t = 50)
exp_F(Ne = 10, t = 50)
}
\references{
\itemize{
  \item{Falconer DS, Mackay TFC. 1996. Introduction to Quantitative Genetics. 4th edition. Longman, Essex, U.K.}
}
}
\seealso{
\code{\link{ip_F}}
}
