% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_functions.R
\name{model_labels}
\alias{model_labels}
\title{Using labels as coefficient names in tables of coefficients.}
\usage{
model_labels(model, intercept = TRUE)
}
\arguments{
\item{model}{A generalised linear model.}

\item{intercept}{Logical, should the intercept be added to the list of coefficients?}
}
\description{
\code{model_labels} replaces row names in \code{glm_coef} with labels from the original data frame.
}
\details{
\code{model_labels} does not handle yet interaction terms, see examples.

Please read the Vignette on Regression for more examples.
}
\examples{
require(dplyr, quietly = TRUE)
require(sjlabelled, quietly = TRUE)

data(birthwt, package = "MASS")
birthwt <- birthwt \%>\%
  mutate(
    smoke = factor(smoke, labels = c("Non-smoker", "Smoker")),
    race = factor(race, labels = c("White", "African American", "Other"))
  ) \%>\%
  var_labels(
    bwt = "Birth weight (g)",
    smoke = "Smoking status",
    race = "Race"
  )

model_norm <- lm(bwt ~ smoke + race, data = birthwt)

glm_coef(model_norm, labels = model_labels(model_norm))

model_int <- lm(formula = bwt ~ smoke * race, data = birthwt)

model_int \%>\%
  glm_coef(labels = c(
    model_labels(model_int),
    "Smoker: African American",
    "Smoker: Other"
  ))
}
