% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_dct_template.R,
%   R/generate_dct_templates.R
\name{generate_dct_template}
\alias{generate_dct_template}
\alias{generate_dct_templates}
\title{DCT templates}
\usage{
generate_dct_template(
  prefix = paste(sample(letters, 4), collapse = ""),
  output = NULL,
  overwrite = FALSE,
  createDirs = FALSE,
  addComments = TRUE,
  stopOnIllegalChars = FALSE
)

generate_dct_templates(
  x,
  outputDir = NULL,
  createDirs = FALSE,
  addComments = FALSE,
  stopOnIllegalChars = FALSE
)
}
\arguments{
\item{prefix, x}{The prefix (\code{prefix}) or vector of prefixes (\code{x}) to use.}

\item{output, outputDir}{The filename or directory to which to write the
templates.}

\item{overwrite}{Whether to overwrite any existing files.}

\item{createDirs}{Whether to recursively create the directories if the path
specified in \code{output} or \code{outputPath} does not yet exist.}

\item{addComments}{Whether to add comments to the DCT specification as extra
explanation.}

\item{stopOnIllegalChars}{DCT identifier prefixes can only contain upper- and
lowercase letters and underscores. This argument specifies whether to remove
illegal characters with a warning, or whether to throw an error (and stop) if
illegal characters are found,}
}
\value{
The DCT template(s), either invisibly (if \code{output} or \code{outputDir} is
specified) or visibly.
}
\description{
These functions can generate one or more empty DCT templates.
}
