% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_best_model.lmerModLmerTest.R
\name{find_best_model.lmerModLmerTest}
\alias{find_best_model.lmerModLmerTest}
\title{Returns the best combination of predictors for lmerTest objects.}
\usage{
\method{find_best_model}{lmerModLmerTest}(fit, interaction = TRUE,
  fixed = NULL, ...)
}
\arguments{
\item{fit}{A merModLmerTest object.}

\item{interaction}{Include interaction term.}

\item{fixed}{Additional formula part to add at the beginning of
each formula}

\item{...}{Arguments passed to or from other methods.}
}
\value{
list containing all combinations.
}
\description{
Returns the best combination of predictors for lmerTest objects.
}
\examples{
\dontrun{
library(psycho)
library(lmerTest)

data <- standardize(iris)
fit <- lmerTest::lmer(Sepal.Length ~ Sepal.Width + Petal.Length + (1|Species), data=data)

best <- find_best_model(fit)
best_formula <- best$formula
best$table

}

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
