% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_R2.R
\name{get_R2.merMod}
\alias{get_R2.merMod}
\title{R2 and adjusted R2 for GLMMs.}
\usage{
\method{get_R2}{merMod}(fit, ...)
}
\arguments{
\item{fit}{A GLMM.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
R2 and adjusted R2 for GLMMs.
}
\examples{
\dontrun{
library(psycho)

fit <- lmerTest::lmer(Tolerating ~ Adjusting + (1|Sex), data=psycho::affective)
fit <- lme4::glmer(Sex ~ Adjusting + (1|Salary), data=na.omit(psycho::affective), family="binomial")

get_R2(fit)

}

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
