% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_artifacts.R
\name{impute_artifacts}
\alias{impute_artifacts}
\title{Impute missing and impossible artifact values}
\usage{
impute_artifacts(sample_id = NULL, construct_id = NULL, measure_id = NULL,
  art_vec, cat_moderator_matrix, impute_method = "bootstrap_mod",
  art_type = "rel", n_vec = rep(1, length(art_vec)))
}
\arguments{
\item{sample_id}{Study ID value.}

\item{construct_id}{Construct name or other designator.}

\item{measure_id}{Measure name or other designator.}

\item{art_vec}{Vector of artifact values}

\item{cat_moderator_matrix}{Matrix of categorical moderators}

\item{impute_method}{Method to use for imputing artifacts. Choices are:
\itemize{
\item bootstrap_mod = select random values from the most specific moderator categories available.
\item bootstrap_full = select random values from the full vector of artifacts.
\item simulate_mod = generate random values from the distribution with the mean and variance of observed artifacts from the most specific moderator categories available
(uses rnorm for u ratios and rbeta for reliability values).
\item simulate_full = generate random values from the distribution with the mean and variance of all observed artifacts (uses rnorm for u ratios and rbeta for reliability values).
\item wt_mean_mod = replace missing values with the sample-size weighted mean of the distribution of artifacts from the most specific moderator categories available.
\item wt_mean_full = replace missing values with the sample-size weighted mean of the full distribution of artifacts.
\item unwt_mean_mod = replace missing values with the unweighted mean of the distribution of artifacts from the most specific moderator categories available.
\item unwt_mean_full = replace missing values with the unweighted mean of the full distribution of artifacts.
\item replace_unity = replace missing values with 1 (not recommended)
\item stop = stop evaluations when missing artifacts are encountered
}}

\item{art_type}{Type of artifacts to be imputed: "rel" for reliabilities and "u" for u ratios.}

\item{n_vec}{Vector of sample sizes associated with the elements of art_vec.}
}
\value{
A vector of artifacts that includes imputed values.
}
\description{
Impute missing and impossible artifact values
}
\examples{
# art_vec <- c(.6, .7, NA, .8, .9, NA)
# cat_moderator_matrix <- matrix(c(rep(1, 3), rep(2, 3)))
# art_type <- "rel"
# n_vec <- c(50, 200, 100, 50, 200, 100)
#
# ## Compute unweighted means
# impute_artifacts(art_vec = art_vec, cat_moderator_matrix = cat_moderator_matrix,
#                 impute_method = "unwt_mean_full", art_type = art_type, n_vec = n_vec)
# impute_artifacts(art_vec = art_vec, cat_moderator_matrix = cat_moderator_matrix,
#                 impute_method = "unwt_mean_mod", art_type = art_type, n_vec = n_vec)
#
# ## Compute weighted means
# impute_artifacts(art_vec = art_vec, cat_moderator_matrix = cat_moderator_matrix,
#                 impute_method = "wt_mean_full", art_type = art_type, n_vec = n_vec)
# impute_artifacts(art_vec = art_vec, cat_moderator_matrix = cat_moderator_matrix,
#                 impute_method = "wt_mean_mod", art_type = art_type, n_vec = n_vec)
#
# ## Simulate from distribution with the mean and variance of the observed artifacts
# impute_artifacts(art_vec = art_vec, cat_moderator_matrix = cat_moderator_matrix,
#                 impute_method = "simulate_full", art_type = art_type, n_vec = n_vec)
# impute_artifacts(art_vec = art_vec, cat_moderator_matrix = cat_moderator_matrix,
#                 impute_method = "simulate_mod", art_type = art_type, n_vec = n_vec)
#
# ## Sample random values from the observed distribution of artifacts
# impute_artifacts(art_vec = art_vec, cat_moderator_matrix = cat_moderator_matrix,
#                 impute_method = "bootstrap_mod", art_type = art_type, n_vec = n_vec)
# impute_artifacts(art_vec = art_vec, cat_moderator_matrix = cat_moderator_matrix,
#                 impute_method = "bootstrap_full", art_type = art_type, n_vec = n_vec)
#
# ## If all values are missing from a moderator category, the program will run
# ## full-data imputation on the remaining missing values:
# impute_artifacts(art_vec = c(NA, NA, NA, .7, .8, .9), cat_moderator_matrix = cat_moderator_matrix,
#                 impute_method = "bootstrap_mod", art_type = art_type, n_vec = n_vec)
}
\keyword{internal}
