% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibliography.R
\name{generate_bib}
\alias{generate_bib}
\title{Generate a list of references included in meta-analyses}
\usage{
generate_bib(ma_obj = NULL, additional_citekeys = NULL, bib = NULL,
  analyses = "all", match = c("all", "any"), style = "apa",
  output_format = c("word", "html", "pdf", "text", "Rmd", "biblatex",
  "citekeys"), file = NULL, header = list())
}
\arguments{
\item{ma_obj}{A psychmeta meta-analysis object with \code{citekeys} supplied.}

\item{additional_citekeys}{Additional citekeys to include in the reference list.}

\item{bib}{A BibTeX file containing the citekeys for the meta-analyses.}

\item{analyses}{Which analyses to extract references for? See \code{\link{filter_ma}} for details.}

\item{match}{Match \code{all} or \code{any} of the filter criteria? See \code{\link{filter_ma}} for details.}

\item{style}{References should be formatted in what style? Can be the style ID for any \url{https://github.com/citation-style-language/styles}{CSL style} (formatted examples of styles are available from the \url{https://zotero.org/styles}{Zotero Style Repository}). Defaults to APA style. (Requires an internet connection to retrieve styles. If unavailable, references will be rendered in Chicago style.)}

\item{output_format}{The format of the output reference list. Available options are Word (default), HTML, PDF (requires the \code{tinytex} package), Rmarkdown, plain text, and BibLaTeX. Returning only the item citekeys is also possible.}

\item{file}{The filename or filepath for the output file. If \code{NULL}, file will be saved as \code{reference_list}. Set to \code{"console"} or \code{"print"} to output directly to the R console.}

\item{header}{A list of YAML header parameters to pass to \code{link{rmarkdown::render}}.}
}
\value{
A formatted reference list.
}
\description{
This function generates a list of studies contributing to a meta-analysis
}
\examples{
\dontrun{
ma_obj <- ma_r(ma_method = "ic", rxyi = rxyi, n = n, rxx = rxxi, ryy = ryyi,
               construct_x = x_name, construct_y = y_name, sample_id = sample_id,
               moderators = moderator, citekey = citekey, data = data_r_meas_multi)

generate_bib(ma_obj, analyses="all", match=c("all", "any"),
bib=system.file("sample_bibliography.bib", package="psychmeta"), style="apa",
output_format="word", header=list())
}
}
