% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma_r_ad.R
\name{ma_r_ad}
\alias{ma_r_ad}
\title{Artifact-distribution meta-analysis of correlations}
\usage{
ma_r_ad(ma_obj, ad_obj_x = NULL, ad_obj_y = NULL,
  correction_method = "auto", use_ic_ads = "tsa", correct_rxx = TRUE,
  correct_ryy = TRUE, correct_rr_x = TRUE, correct_rr_y = TRUE,
  indirect_rr_x = TRUE, indirect_rr_y = TRUE, residual_ads = TRUE,
  sign_rxz = 1, sign_ryz = 1, decimals = 2, ...)
}
\arguments{
\item{ma_obj}{Meta-analysis object of correlations or d values (regardless of input metric, output metric will be r).}

\item{ad_obj_x}{Artifact-distribution object for the X variable (output of the \code{\link{create_ad}} function).
If ma_obj is of the class \code{ma_master} (i.e,. the output of \code{\link{ma_r}} or \code{\link{ma_d}}), the object supplied for
\code{ad_obj_x} must be a named list of artifact distributions with names corresponding to the "X" constructs in the meta-analyses contained within \code{ma_obj}.}

\item{ad_obj_y}{Artifact-distribution object for the Y variable (output of the \code{create_ad} function).
If ma_obj is of the class \code{ma_master}, the object supplied for \code{ad_obj_y} must be a named list of artifact distributions with names
corresponding to the "Y" constructs in the meta-analyses contained within \code{ma_obj}.}

\item{correction_method}{One of the following methods for correcting artifacts: "auto", "meas", "uvdrr", "uvirr", "bvdrr", "bvirr",
"rbOrig", "rb1Orig", "rb2Orig", "rbAdj", "rb1Adj", and "rb2Adj".
(note: "rb1Orig", "rb2Orig", "rb1Adj", and "rb2Adj" can only be used when Taylor series artifact distributions are provided and "rbOrig" and "rbAdj" can only
be used when interative artifact distributions are provided). See "Details" for descriptions of the available methods.}

\item{use_ic_ads}{Determines whether artifact distributions should be extracted from the individual correction results in \code{ma_obj}.
Only evaluated when \code{ad_obj_x} or \code{ad_obj_y} is NULL and \code{ma_obj} does not contain individual correction results.
Use one of the following commands: \code{tsa} to use the Taylor series method or \code{int} to use the interactive method.}

\item{correct_rxx}{Logical argument that determines whether to correct the X variable for measurement error (\code{TRUE}) or not (\code{FALSE}).}

\item{correct_ryy}{Logical argument that determines whether to correct the Y variable for measurement error (\code{TRUE}) or not (\code{FALSE}).}

\item{correct_rr_x}{Logical argument that determines whether to correct the X variable for range restriction (\code{TRUE}) or not (\code{FALSE}).}

\item{correct_rr_y}{Logical argument that determines whether to correct the Y variable for range restriction (\code{TRUE}) or not (\code{FALSE}).}

\item{indirect_rr_x}{If \code{correct_rr_x} = \code{TRUE}: Logical argument that determines whether to correct for indirect range restriction in X (\code{TRUE}) or not (\code{FALSE}).}

\item{indirect_rr_y}{If \code{correct_rr_y} = \code{TRUE}: Logical argument that determines whether to correct for indirect range restriction in Y (\code{TRUE}) or not (\code{FALSE}).}

\item{residual_ads}{Logical argument that determines whether to use residualized variances (\code{TRUE}) or observed variances (\code{FALSE}) of artifact distributions to estimate \code{sd_rho}.}

\item{sign_rxz}{Sign of the relationship between X and the selection mechanism (for use with the bvirr \code{correction_method} only).}

\item{sign_ryz}{Sign of the relationship between Y and the selection mechanism (for use with the bvirr \code{correction_method} only).}

\item{decimals}{Number of decimal places to which interactive artifact distributions should be rounded (default is 2 decimal places).
Rounding artifact distributions can help to consolidate trivially different values and speed up the computation of meta-analyses (especially in simulations).}

\item{...}{Additional arguments.}
}
\value{
A list object of the classes \code{psychmeta}, \code{ma_r_as_r} or \code{ma_d_as_r}, \code{ma_bb}, and \code{ma_ad} (and that inherits class \code{ma_ic} from \code{ma_obj})
}
\description{
This function computes artifact distribution meta-analyses of correlations. It supports interactive methods as well as Taylor series methods for all available corrections.
}
\details{
The options for \code{correction_method} are:
\itemize{
\item{"auto"}{\cr Automatic selection of the most appropriate correction procedure, based on the available artifacts and the logical arguments provided to the function. (default)}
\item{"meas"}{\cr Correction for measurement error only.}
\item{"uvdrr"}{\cr Correction for univariate direct range restriction (i.e., Case II). The choice of which variable to correct for range restriction is made using the \code{correct_rr_x} and \code{correct_rr_y} arguments.}
\item{"uvirr"}{\cr Correction for univariate indirect range restriction (i.e., Case IV). The choice of which variable to correct for range restriction is made using the \code{correct_rr_x} and \code{correct_rr_y} arguments.}
\item{"bvdrr"}{\cr Correction for bivariate direct range restriction. Use with caution: This correction is an approximation only and is known to have a positive bias.}
\item{"bvirr"}{\cr Correction for bivariate indirect range restriction (i.e., Case V).}
\item{"rbOrig"}{\cr Not recommended: Raju and Burke's version of the correction for direct range restriction, applied interactively. We recommend using "uvdrr" instead.}
\item{"rbAdj"}{\cr Not recommended: Raju and Burke's version of the correction for direct range restriction, applied interactively. Adjusted to account for range restriction in the reliability of the Y variable. We recommend using "uvdrr" instead.}
\item{"rb1Orig"}{\cr Not recommended: Raju and Burke's version of the correction for direct range restriction, applied using their TSA1 method. We recommend using "uvdrr" instead.}
\item{"rb1Adj"}{\cr Not recommended: Raju and Burke's version of the correction for direct range restriction, applied using their TSA1 method. Adjusted to account for range restriction in the reliability of the Y variable. We recommend using "uvdrr" instead.}
\item{"rb2Orig"}{\cr Not recommended: Raju and Burke's version of the correction for direct range restriction, applied using their TSA2 method. We recommend using "uvdrr" instead.}
\item{"rb2Adj"}{\cr Not recommended: Raju and Burke's version of the correction for direct range restriction, applied using their TSA2 method. Adjusted to account for range restriction in the reliability of the Y variable. We recommend using "uvdrr" instead.}
}
}
\section{Note}{

The difference between "rb" methods with the "orig" and "adj" suffixes is that the original does not account for the impact of range restriction on criterion reliabilities, whereas
the adjusted procedure attempts to estimate the applicant reliability information for the criterion. The "rb" procedures are included for posterity: We strongly recommend using
the "uvdrr" procedure to appropriately correct for univariate range restriction.
}

\examples{
## Compute barebones meta-analysis
ma_obj <- ma_r_bb(r = rxyi, n = n, correct_bias = FALSE,
                           conf_method = "norm", cred_method = "norm", data = data_r_mcdaniel_1994)

## Construct artifact distribution for X
ad_obj_x <- create_ad_tsa(mean_rxxi = data_r_mcdaniel_1994$Mrxxi[1],
                          var_rxxi = data_r_mcdaniel_1994$SDrxxi[1]^.5,
                          ux = data_r_mcdaniel_1994$ux,
                          wt_ux = data_r_mcdaniel_1994$`ux frequency`)

## Construct artifact distribution for Y
ad_obj_y <- create_ad_tsa(rxxi = data_r_mcdaniel_1994$ryyi,
                          wt_rxxi = data_r_mcdaniel_1994$`ryyi frequency`)

## Compute artifact-distribution meta-analysis, correcting for measurement error only
ma_r_ad(ma_obj = ma_obj, ad_obj_x = ad_obj_x, ad_obj_y = ad_obj_y, correction_method = "meas")

## Compute artifact-distribution meta-analysis, correcting for univariate direct range restriction
ma_r_ad(ma_obj = ma_obj, ad_obj_x = ad_obj_x, ad_obj_y = ad_obj_y, correction_method = "uvdrr",
        correct_rr_y = FALSE, indirect_rr_x = FALSE)
}
\references{
Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
Thousand Oaks, CA: Sage. \url{https://doi.org/10/b6mg}. Chapter 4.

Law, K. S., Schmidt, F. L., & Hunter, J. E. (1994).
Nonlinearity of range corrections in meta-analysis: Test of an improved procedure.
\emph{Journal of Applied Psychology, 79}(3), 425–438. \url{https://doi.org/10.1037/0021-9010.79.3.425}

Dahlke, J. A., & Wiernik, B. M. (2017).
\emph{One of these artifacts is not like the others: New methods to account for the unique implications of indirect range-restriction corrections in organizational research}.
Unpublished manuscript.

Raju, N. S., & Burke, M. J. (1983).
Two new procedures for studying validity generalization.
\emph{Journal of Applied Psychology, 68}(3), 382–395. \url{https://doi.org/10.1037/0021-9010.68.3.382}
}
