% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{meanStrAov}
\alias{meanStrAov}
\title{meanStrAov}
\usage{
meanStrAov(aovObj, effect, level, unit = "ms", numDigits = 0)
}
\arguments{
\item{aovObj}{Output from aov or ezANOVA (NB. ezANOVA must be called with detailed = TRUE)}

\item{effect}{Effect to return}

\item{level}{Level of effect}

\item{unit}{"ms" vs. "mv" vs. "\%"}

\item{numDigits}{"ms" vs. "mv" vs. "\%"}
}
\value{
character
}
\description{
Returns marginal means from ezANOVA object for requested effect in Latex format.
Assumes means added to aovObj (e.g., aovObj$means <- model.tables(aovObj$aov, type = "mean").
}
\examples{
# Example 1:
# create dataframe and add data with 2(Comp: comp vs. incomp) and 2(Side: left vs. right)
dat <- createDF(nVP = 20, nTrl = 1,
                design = list("Comp" = c("comp", "incomp"),
                              "Side" = c("left", "right")))

dat <- addDataDF(dat, RT = list("Comp:Side comp:left"    = c(500, 150, 100),
                                "Comp:Side comp:right"   = c(500, 150, 100),
                                "Comp:Side incomp:left"  = c(520, 150, 100),
                                "Comp:Side incomp:right" = c(520, 150, 100)))

aovRT <- aov(RT ~ Comp*Side + Error(VP/(Comp*Side)), dat)
aovRT <- aovTable(aovRT)

meanString <- meanStrAov(aovRT, "Comp", "comp")
meanString <- meanStrAov(aovRT, "Comp:Side", "incomp:left")

# or using ezANOVA
library(ez)
aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp, Side),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovTable(aovRT)

meanString <- meanStrAov(aovRT, "Comp", "comp")
meanString <- meanStrAov(aovRT, "Comp:Side", "incomp:left")

}
