% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_borrow.R
\name{psrwe_borrow}
\alias{psrwe_borrow}
\title{Get number of subjects borrowed from each statum}
\usage{
psrwe_borrow(
  dtaps,
  total_borrow,
  method = c("distance", "inverse_distance"),
  ...
)
}
\arguments{
\item{dtaps}{A class \code{PSRWE_DTA} or \code{PSRWE_DTA_MAT} object.}

\item{total_borrow}{Total number of subjects to be borrowed}

\item{method}{Method to split \code{total_borrow} for a class
\code{PSRWE_DTA} object, which can be based on distance (\code{method =
"distance"}) or inverse distance (\code{method = "inverse_distance"}).
Ignored for class \code{PSRWE_DTA_MAT} object.}

\item{...}{Additional parameters for \code{\link{summary.PSRWE_DTA}}.}
}
\value{
A class \code{PSRWE_BORR} list. It appends the following items to
    the \code{dtaps}:

  \itemize{

    \item{Proportion}{Proportion splitting the number of total borrow among
    strata.}

    \item{N_Borrow}{The number of to be borrowed subjects in each stratum.}

    \item{Alpha}{Weight parameter value in each stratum.}
}
}
\description{
Based on PS distances or number of current control subjects, split the total
number of subjects to be borrowed from the external data source to each
stratum
}
\examples{
data(ex_dta)
dta_ps <- psrwe_est(ex_dta,
                     v_covs = paste("V", 1:7, sep = ""),
                     v_grp = "Group",
                     cur_grp_level = "current")

ps_borrow <- psrwe_borrow(total_borrow = 20, dta_ps)
ps_borrow

## Use different similarity metric
ps_borrow_omkss <- psrwe_borrow(total_borrow = 20, dta_ps,
                                 metric = "omkss")
ps_borrow_omkss

}
