% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_functions.r
\name{optCL}
\alias{optCL}
\title{Calculate the Optimal Visual Testing Confidence Level}
\usage{
optCL(
  obj = NULL,
  varname = NULL,
  b = NULL,
  v = NULL,
  resdf = Inf,
  level = 0.95,
  quasi_vars = NULL,
  add_ref = TRUE,
  grid_range = c(0.75, 0.99),
  grid_length = 100,
  adjust = p.adjust.methods[c(8, 1:7)]
)
}
\arguments{
\item{obj}{A model object, on which \code{coef} and \code{vcov} can be called. 
Either \code{obj} and \code{varname} or \code{b} and \code{v} must be specified.}

\item{varname}{The name of a variable whose coefficients will be used.}

\item{b}{Optional vector of coefficients to be passed into the function.
it overrides the coefficients in \code{obj}. Either \code{obj} and 
\code{varname} or \code{b} and \code{v} must be specified.}

\item{v}{Optional variance-covariance matrix.  This can be specified 
even if \code{obj} and \code{varname} are specified.  It replaces the
variance-covaraince matrix from the model.}

\item{resdf}{If only \code{b} and \code{v} are passed in, this gives 
the residual degrees of freedom for the t-statistics.}

\item{level}{The confidence level to use for testing.}

\item{quasi_vars}{An optional vector of quasi-variances that will be
used to make the confidence intervals.}

\item{add_ref}{If \code{obj} and \code{varname} are passed in, 
an optional 0 is added to the front of the vector of coefficients, 
along with a leading row and column of zeros on the variance-covariance
matrix to represent the reference category.}

\item{grid_range}{The range of values over which to do the grid search.}

\item{grid_length}{The number of values in the grid.}

\item{adjust}{String giving the method used to adjust the p-values for 
multiplicity.  All methods allowed in \code{p.adjust.methods} are 
permitted.  None is the default.}
}
\value{
A list with the following elements: 
\describe{
  \item{opt_levels}{The optimal confidence levels that all have 
  identical minimal error rates. }
  \item{opt_diffs}{The sum of differences between upper and lower bounds that 
  characterize the appropriate visual tests.  Larger numbers are better.}
  \item{opt_errors}{The proportion of errors across all simple contrasts.}
  \item{lev_errors}{The proportion of errors made at the nominal 
  significance level.}
  \item{tot_comps}{The total number of comparisons}
  \item{lev_dat}{If there are inferential errors at the nominal level, 
  this is a data frame that has all of the information about which 
  comparisons are not appropriately represented by the overlaps in 
  confidence intervals.}
  \item{err_dat}{If there are inferential errors at the optimal level, 
  this is a data frame that has all of the information about which 
  comparisons remain not appropriately represented by the overlaps in 
  optimized confidence intervals.}
}
}
\description{
Calculates the Optimal Visual Testing (OVT) confidence level.  The
OVT level is a level you can use to make confidence intervals such that
the overlapping (or non-overlapping) of confidence intervals preserves
the pairwise testing results. That is, statistically different 
estimates have confidence intervals that do not overlap and statistically
indistinguishable intervals have confidence intervals that do overlap. 
It does not always work perfectly, but it generally results in fewer
inferential errors than the nominal level.
}
\examples{
data(wvs)
wvs$civ2 <- "Other"
wvs$civ2 <- ifelse(wvs$civ == 9, 
                   "Western", 
                   wvs$civ2)
wvs$civ2 <- ifelse(wvs$civ == 6, 
                   "Latin American", 
                   wvs$civ2)
wvs$civ2 <- as.factor(wvs$civ2)

intmod <- lm(resemaval ~ civ2 * pct_secondary, 
             data=wvs)

ss2 <- simple_slopes(intmod, 
                     "pct_secondary", 
                     "civ2")
o2 <- optCL(b=ss2$est$slope, v=ss2$v)
}
