% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.pspatreg.R
\name{summary.pspatreg}
\alias{summary.pspatreg}
\title{Summary method for objects of class pspatreg.}
\usage{
\method{summary}{pspatreg}(object, ...)
}
\arguments{
\item{object}{\emph{pspatreg} object fitted using \code{\link[pspatreg]{pspatfit}} function.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of class \emph{summary.pspatreg}
}
\description{
This method summarizes both spatial (2-dimension) and
  spatio-temporal (3-dimension) \emph{pspatreg} objects.
  The tables include information of:
  \itemize{
     \item The spatial (or spatio-temporal) trends. When the model is ANOVA
       the trend is decomposed in main and interaction effects.
     \item The parametric and non-parametric covariates.
     \item The \eqn{\rho} parameter when the model is SAR.
     \item The \eqn{\phi} parameter when the model is spatio-temporal
       with a first-order autorregressive in the noise.
 }
}
\examples{
 # See examples for \code{\link{pspatfit}} function.

}
\seealso{
\itemize{
  \item \code{\link{pspatfit}} estimate spatial or spatio-temporal semiparametric 
    regression models.
  \item \code{\link{print.summary.pspatreg}} print objects of class \emph{summary.pspatreg}
}
}
\author{
\tabular{ll}{ 
  Roman Minguez  \tab \email{roman.minguez@uclm.es} \cr
  Roberto Basile \tab \email{roberto.basile@univaq.it} \cr Maria Durban \tab
  \email{mdurban@est-econ.uc3m.es} \cr Gonzalo Espana-Heredia \tab
  \email{gehllanza@gmail.com} \cr 
 }
}
