% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_bw.R
\name{glm_bw}
\alias{glm_bw}
\title{Function for backward selection of Linear and Logistic regression models.}
\usage{
glm_bw(
  data,
  formula = NULL,
  Outcome = NULL,
  predictors = NULL,
  p.crit = 1,
  cat.predictors = NULL,
  spline.predictors = NULL,
  int.predictors = NULL,
  keep.predictors = NULL,
  nknots = NULL,
  model_type = "binomial"
)
}
\arguments{
\item{data}{A data frame.}

\item{formula}{A formula object to specify the model as normally used by glm.
See under "Details" and "Examples" how these can be specified.}

\item{Outcome}{Character vector containing the name of the outcome variable.}

\item{predictors}{Character vector with the names of the predictor variables.
At least one predictor variable has to be defined. Give predictors unique names
and do not use predictor name combinations with numbers as, age2, gnder10, etc.}

\item{p.crit}{A numerical scalar. P-value selection criterium. A value of 1
provides the pooled model without selection.}

\item{cat.predictors}{A single string or a vector of strings to define the
categorical variables. Default is NULL categorical predictors.}

\item{spline.predictors}{A single string or a vector of strings to define the
(restricted cubic) spline variables. Default is NULL spline predictors. See details.}

\item{int.predictors}{A single string or a vector of strings with the names of the variables that form
an interaction pair, separated by a “:” symbol.}

\item{keep.predictors}{A single string or a vector of strings including the variables that are forced
in the model during predictor selection. All type of variables are allowed.}

\item{nknots}{A numerical vector that defines the number of knots for each spline predictor separately.}

\item{model_type}{A character vector. If "binomial" a logistic regression model is used (default) and for 
"linear" a linear regression model is used.}
}
\value{
An object of class \code{smods} (single models) from
 which the following objects can be extracted: original dataset as \code{data}, 
 model at each selection step \code{RR_model}, final selected model as \code{RR_model_final}, 
 p-values at final step \code{multiparm_final}, and at each step as \code{multiparm}, 
 formula object at final step as \code{formula_final}, 
 and at each step as \code{formula_step} and for start model as \code{formula_initial}, 
 predictors included at each selection step as \code{predictors_in}, predictors excluded
 at each step as \code{predictors_out}, and \code{Outcome}, \code{p.crit}, \code{call},
 \code{model_type}, \code{predictors_final} for names of predictors in final selection step and 
 \code{predictors_initial} for names of predictors in start model and \code{keep.predictors} for
 variables that are forced in the model during selection.
}
\description{
\code{glm_bw} Backward selection of Linear and Logistic regression
 models in single dataset using as selection method the likelihood-ratio test.
}
\details{
A typical formula object has the form \code{Outcome ~ terms}. Categorical variables has to
 be defined as \code{Outcome ~ factor(variable)}, restricted cubic spline variables as
 \code{Outcome ~ rcs(variable, 3)}. Interaction terms can be defined as
 \code{Outcome ~ variable1*variable2} or \code{Outcome ~ variable1 + variable2 + variable1:variable2}.
 All variables in the terms part have to be separated by a "+".
}
\examples{

data1 <- subset(psfmi::lbpmilr, Impnr==1) # extract first imputed dataset
res_single <- glm_bw(data=data1, p.crit = 0.05, formula=Chronic ~
       Tampascale + Smoking + factor(Satisfaction), model_type="binomial")
         
res_single$RR_model_final

res_single <- glm_bw(data=data1, p.crit = 0.05, formula=Pain ~
         Tampascale  + Smoking + factor(Satisfaction), model_type="linear")
         
res_single$RR_model_final

}
\references{
http://missingdatasolutions.rbind.io/
}
\seealso{
\code{\link{psfmi_perform}}
}
\author{
Martijn Heymans, 2021
}
