% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.plr.R
\name{print.summary.plr}
\alias{print.summary.plr}
\title{Print Summary Polygonal Linear Regression}
\usage{
\method{print}{summary.plr}(x, digits = max(3L, getOption("digits") -
  3L), concise = FALSE, ...)
}
\arguments{
\item{x}{an object of the class "\emph{summary.plr}".}

\item{digits}{non-null value for \code{digits} specifies the minimum number of significant 
digits to be printed in values.}

\item{concise}{a \emph{logical} used to determine the type of digits.}

\item{...}{further arguments special methods could require.}
}
\description{
print arguments of the class "\emph{summary.plr}" and returns it \emph{invisibly} (via \code{\link[base]{invisible}} (x)).
}
\examples{
yp <- psim(50, 10) #simulate 50 polygons of 10 sides
xp1 <- psim(50, 10) #simulate 50 polygons of 10 sides
xp2 <- psim(50, 10) #simulate 50 polygons of 10 sides
e <- new.env()
e$yp <- yp
e$xp1 <- xp1
e$xp2 <- xp2
fit <- plr(yp~xp1 + xp2, data = e)
s <- summary(fit)  
s
}
