% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_treatment_list.R
\name{sim_treatment_list}
\alias{sim_treatment_list}
\title{Input treatment details for a simulation study}
\usage{
sim_treatment_list(treatment_list)
}
\arguments{
\item{treatment_list}{named list of objects of class \code{Treatment} created
by \code{treatment_details()}.}
}
\value{
Object of class \code{\link[=SimTreatmentList-class]{SimTreatmentList}}.
}
\description{
A function for defining which treatment scenarios should be evaluated as
part of a simulation study.
}
\examples{

treatment_scenarios <- sim_treatment_list(
  list(
    "Standard" = treatment_details("trt", prior_normal(0, 1000))
  )
)

}
\seealso{
Other simulation classes: 
\code{\link{sim_borrowing_list}()},
\code{\link{sim_covariate_list}()},
\code{\link{sim_data_list}()},
\code{\link{sim_outcome_list}()}
}
\concept{simulation classes}
