% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniform_prior.R
\docType{class}
\name{UniformPrior-class}
\alias{UniformPrior-class}
\alias{.uniform_prior}
\title{\code{UniformPrior} Class}
\description{
A class for defining uniform priors to be translated to Stan code.
Objects of class \code{UniformPrior} should not be created directly but by
the constructor \code{\link[=uniform_prior]{uniform_prior()}}.
}
\section{Slots}{

\describe{
\item{\code{stan_code}}{character. Stan implementation of the prior, with
placeholders for uniform stan function parameters surrounded with
\verb{\{\{} and \verb{\}\}} to be replaced with \code{\link[glue:glue]{glue::glue()}}.}

\item{\code{n_param}}{integer. Number of prior parameters (2).}

\item{\code{constraint}}{character. Support of prior distribution,
\verb{"<lower=}alpha\verb{, upper=}beta\verb{>"}.}

\item{\code{alpha}}{numeric. Lower bound.}

\item{\code{beta}}{numeric. Upper bound (>\code{alpha}).}
}}

\seealso{
Other prior classes: 
\code{\link{Prior-class}},
\code{\link{PriorBernoulli-class}},
\code{\link{PriorBeta-class}},
\code{\link{PriorCauchy-class}},
\code{\link{PriorExponential-class}},
\code{\link{PriorGamma-class}},
\code{\link{PriorHalfCauchy-class}},
\code{\link{PriorHalfNormal-class}},
\code{\link{PriorNormal-class}},
\code{\link{PriorPoisson-class}}
}
\concept{prior classes}
