% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_terminal}
\alias{ps_terminal}
\title{Terminal device of the process}
\usage{
ps_terminal(p)
}
\arguments{
\item{p}{Process handle.}
}
\value{
Character scalar.
}
\description{
Returns the terminal of the process. Not implemented on Windows, always
returns \code{NA_character_}. On Unix it returns \code{NA_character_} if the
process has no terminal.
}
\details{
Works for zombie processes.
}
\seealso{
Other process handle functions: \code{\link{ps_children}},
  \code{\link{ps_cmdline}}, \code{\link{ps_cpu_times}},
  \code{\link{ps_create_time}}, \code{\link{ps_cwd}},
  \code{\link{ps_environ}}, \code{\link{ps_exe}},
  \code{\link{ps_handle}}, \code{\link{ps_interrupt}},
  \code{\link{ps_is_running}}, \code{\link{ps_kill}},
  \code{\link{ps_memory_info}}, \code{\link{ps_name}},
  \code{\link{ps_num_fds}}, \code{\link{ps_num_threads}},
  \code{\link{ps_open_files}}, \code{\link{ps_pid}},
  \code{\link{ps_ppid}}, \code{\link{ps_resume}},
  \code{\link{ps_send_signal}}, \code{\link{ps_status}},
  \code{\link{ps_suspend}}, \code{\link{ps_terminate}},
  \code{\link{ps_uids}}, \code{\link{ps_username}}
}
\concept{process handle functions}
\section{Examples}{
\Sexpr[stage=install,strip.white=FALSE,results=rd]{ps:::decorate_examples('
p <- ps_handle()
p
ps_terminal(p)
')}
}
