library(provParseR)
library(testthat)

## Loading test data
test.data <- system.file("testdata", "prov3.json", package = "provParseR")
prov <- prov.parse(test.data)

context("Environment access function")
envi.df <- get.environment(prov)
expect_match(class(envi.df), "data.frame")
expect_match(typeof(envi.df$value), "character")
expect_equal (envi.df$label, c("name", "architecture", "operatingSystem", "language", "langVersion",
        "script", "scriptTimeStamp", "workingDirectory", "ddgDirectory", "ddgTimeStamp", 
        "hashAlgorithm"))

context ("Tool information")
tool.df <- get.tool.info(prov)
expect_match(class(tool.df), "data.frame")
expect_match(typeof(tool.df$tool.name), "character")
expect_match(typeof(tool.df$tool.version), "character")
expect_match(typeof(tool.df$json.version), "character")
expect_equal(nrow(tool.df), 1)
expect_equal(ncol(tool.df), 3)
expect_equal (tool.df$tool.name, "provR")
expect_equal (tool.df$tool.version, "1.0.1")
expect_equal (tool.df$json.version, "2.1")

context("Procedure nodes access function")
proc.df <- get.proc.nodes(prov)
expect_match(class(proc.df), "data.frame")
expect_match(typeof(proc.df$name), "character")
expect_match(typeof(proc.df$type), "character")
expect_match(typeof(proc.df$elapsedTime), "double")
expect_match(typeof(proc.df$scriptNum), "integer")
expect_match(typeof(proc.df$startLine), "integer")
expect_match(typeof(proc.df$startCol), "integer")
expect_match(typeof(proc.df$endLine), "integer")
expect_match(typeof(proc.df$endCol), "integer")
expect_equal(nrow(proc.df), 5)
expect_equal(ncol(proc.df), 9)

context("Data nodes access function")
data.df <- get.data.nodes(prov)
expect_match(class(data.df), "data.frame")
expect_match(typeof(data.df$name), "character")
expect_match(typeof(data.df$value), "character")
expect_match(typeof(data.df$valType), "character")
expect_match(typeof(data.df$type), "character")
expect_match(typeof(data.df$scope), "character")
expect_match(typeof(data.df$fromEnv), "logical")
expect_match(typeof(data.df$hash), "character")
expect_match(typeof(data.df$timestamp), "character")
expect_match(typeof(data.df$location), "character")
expect_equal(nrow(data.df), 3)
expect_equal(ncol(data.df), 10)

context("Function nodes access function")
func.df <- get.func.nodes(prov)
expect_match(class(func.df), "data.frame")
expect_equal(nrow(func.df), 0)

context("Procedure-to-procedure edges access function")
proc.proc.df <- get.proc.proc(prov)
expect_match(class(proc.proc.df), "data.frame")
expect_match(typeof(proc.proc.df$informant), "character")
expect_match(typeof(proc.proc.df$informed), "character")
expect_equal(nrow(proc.proc.df), 4)
expect_equal(ncol(proc.proc.df), 3)

context("Data-to-procedure edges access function")
data.proc.df <- get.data.proc(prov)
expect_match(class(data.proc.df), "data.frame")
expect_match(typeof(data.proc.df$entity), "character")
expect_match(typeof(data.proc.df$activity), "character")
expect_equal(nrow(data.proc.df), 2)
expect_equal(ncol(data.proc.df), 3)

context("Procedure-to-data edges access function")
proc.data.df <- get.proc.data(prov)
expect_match(class(proc.data.df), "data.frame")
expect_match(typeof(proc.data.df$entity), "character")
expect_match(typeof(proc.data.df$activity), "character")
expect_equal(nrow(proc.data.df), 3)
expect_equal(ncol(proc.data.df), 3)

context("Function-to-procedure edges access function")
func.proc.df <- get.func.proc(prov)
expect_match(class(func.proc.df), "data.frame")
expect_equal(nrow(func.proc.df), 0)
expect_equal(ncol(func.proc.df), 3)

context("Function-library group nodes access function")
func.lib.df <- get.func.lib(prov)
expect_match(class(func.lib.df), "data.frame")
expect_equal(nrow(func.lib.df), 0)
expect_equal(ncol(func.lib.df), 3)

context("Library nodes access function")
libs.df <- get.libs(prov)
expect_match(class(libs.df), "data.frame")
expect_match(typeof(libs.df$name), "character")
expect_match(typeof(libs.df$version), "character")
expect_equal(nrow(libs.df), 9)
expect_equal(ncol(libs.df), 3)
expect_setequal (libs.df$name, c("base", "datasets", "ggplot2", "graphics", "grDevices",
        "methods", "provR", "stats", "utils"))

context("Scripts access function")
scripts.df <- get.scripts(prov)
expect_match(class(scripts.df), "data.frame")
expect_equal (nrow (scripts.df), 1)
expect_match(typeof(scripts.df$script), "character")
expect_match(typeof(scripts.df$timestamp), "character")
expect_equal(ncol(scripts.df), 2)

context ("Input files")
input.files <- get.input.files (prov)
expect_equal (nrow (input.files), 0)

context ("Output files")
output.files <- get.output.files (prov)
expect_equal (nrow (output.files), 0)

context ("Variables set")
variables.set <- get.variables.set (prov)
expect_equal (nrow (variables.set), 3)

context ("Variables used")
variables.used <- get.variables.used (prov)
expect_equal (nrow (variables.used), 2)



