% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debugView.R
\name{debug.view}
\alias{debug.view}
\title{debug.view}
\usage{
debug.view(..., start.line = "all", script.num = "all")
}
\arguments{
\item{...}{The variable names or file names to be queried.}

\item{start.line}{The line number of the queried variables or files.}

\item{script.num}{The script number of the queried variables or files.}
}
\value{
debug.view returns a data frame containing the information that is displayed,
which contains the following columns:
\itemize{
 	\item name: The name of the variable or file being viewed.
 	\item startLine: The line number the variable or file is associated with. 
 	\item scriptNum: The script number the variable or file is associated with.
 	\item scriptName: The name of the script the variable or file is associated with.
 	\item title: The title of the variable or file when viewed.
 	\item notes: Will display PARTIAL if the variable is a partial snapshot, or
 	             indicate that the provenance directory or a file is not found.
 	             NA otherwise.
}

If there is no data to display, NULL is returned.
}
\description{
debug.view displays the contents of a file or variable at a particular
line of code in a separate view panel.  This is best for large values
like data frames and matrices.
}
\details{
debug.view displays the contents of each file or variable queried.
For snapshots or files with the file extension of .csv or .txt, the data
will be loaded into the debugger environment before it is viewed. Otherwise,
the data will be viewed using the system's default program for that type of file.
}
\examples{
\dontrun{
prov.debug.run("test.R")
debug.view()
debug.view(x)
debug.view("x", y, start.line = 5, script.num = 2)
}

}
