% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_peak_width.R
\name{qc_peak_width}
\alias{qc_peak_width}
\title{Peak width over retention time}
\usage{
qc_peak_width(
  data,
  sample,
  intensity,
  retention_time,
  peak_width = NULL,
  retention_time_start = NULL,
  retention_time_end = NULL,
  remove_na_intensities = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{data}{a data frame containing at least sample names and protein IDs.}

\item{sample}{a character column in the \code{data} data frame that contains the sample names.}

\item{intensity}{a numeric column in the \code{data} data frame that contains intensities. If
\code{remove_na_intensities = FALSE}, this argument is not required.}

\item{retention_time}{a numeric column in the \code{data} data frame that contains retention
times of precursors.}

\item{peak_width}{a numeric column in the \code{data} data frame that contains peak width
information. It is not required if \code{retention_time_start} and \code{retention_time_end}
columns are provided.}

\item{retention_time_start}{a numeric column in the \code{data} data frame that contains the
start time of the precursor elution peak. It is not required if the \code{peak_width} column
is provided.}

\item{retention_time_end}{a numeric column in the \code{data} data frame that contains the end
time of the precursor elution peak. It is not required if the \code{peak_width} column is
provided.}

\item{remove_na_intensities}{a logical value that specifies if sample/grouping combinations
with intensities that are NA (not quantified IDs) should be dropped from the data frame.
Default is TRUE since we are usually interested in the peak width of quantifiable data.}

\item{interactive}{a logical value that specifies whether the plot should be interactive
(default is FALSE).}
}
\value{
A line plot displaying one minute binned median precursor elution peak width over
retention time for each sample.
}
\description{
Plots one minute binned median precursor elution peak width over retention time for each sample.
}
\examples{
\dontrun{
qc_peak_width(
  data,
  sample = r_file_name,
  intensity = fg_quantity,
  retention_time = eg_mean_apex_rt,
  retention_time_start = eg_start_rt,
  retention_time_end = eg_end_rt
)
}
}
