% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_analysis.R
\name{network_analysis}
\alias{network_analysis}
\title{Analyse protein interaction network for significant hits}
\usage{
network_analysis(
  data,
  protein_id,
  string_id,
  organism_id,
  score_threshold = 900,
  binds_treatment = NULL,
  halo_color = NULL,
  plot = TRUE
)
}
\arguments{
\item{data}{A data frame that contains significantly changing proteins (STRINGdb is only able to plot
400 proteins at a time so do not provide more for network plots). Information about treatment binding can be provided and will be displayed as colorful halos around
the proteins in the network.}

\item{protein_id}{The name of the column containing the protein accession numbers.}

\item{string_id}{The name of the column containing STRING database identifiers. These can be obtained from UniProt.}

\item{organism_id}{Numeric organism ID (NCBI taxon-ID). This can be obtained from \href{https://string-db.org/cgi/input?sessionId=bpvps5GS2As6&input_page_show_search=on}{here}.
H. sapiens: 9606, S. cerevisiae: 4932, E. coli: 511145.}

\item{score_threshold}{The interaction score based on \href{https://string-db.org/cgi/info?sessionId=bBP5N4cIf0PA&footer_active_subpage=scores}{STRING}
has to be between 0 and 1000. A score closer to 1000 is related to a higher confidence for the interaction. The default value is 900.}

\item{binds_treatment}{The name of the column containing a logical indicating if the corresponding
protein binds to the treatment. This information can be obtained from different databases, e.g UniProt.}

\item{halo_color}{Optional, A character vector with a color hex-code. This is the color of the halo of proteins that bind the treatment.}

\item{plot}{A logical indicating whether the result should be plotted or returned as a table.}
}
\value{
A network plot displaying interactions of the provided proteins. If \code{binds_treatment} was provided halos around
the proteins show which proteins interact with the treatment. If \code{plot = FALSE} a table with interaction information is
returned.
}
\description{
The STRING database provides a resource for known and predicted protein-protein interactions. The type of
interactions include direct (physical) and indirect (functional) interactions. Through the R package
\code{STRINGdb} this resource if provided to R users. This function provides a convenient wrapper for
\code{STRINGdb} functions that allow an easy use within the protti pipeline.
}
\examples{
\dontrun{
network_analysis(
  data,
  protein_id = pg_protein_accessions,
  string_id = database_string,
  organism_id = 511145,
  binds_treatment = is_known,
  plot = TRUE
)
}
}
