% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc-12-QSO.R
\name{extractQSO}
\alias{extractQSO}
\title{Quasi-Sequence-Order (QSO) Descriptor}
\usage{
extractQSO(x, nlag = 30, w = 0.1)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}

\item{nlag}{The maximum lag, defualt is 30.}

\item{w}{The weighting factor, default is 0.1.}
}
\value{
A length \code{20 + 20 + (2 * nlag)} named vector
}
\description{
This function calculates the Quasi-Sequence-Order (QSO) descriptor
(dim: \code{20 + 20 + (2 * nlag)}, default is 100).
}
\examples{
x = readFASTA(system.file("protseq/P00750.fasta", package = "protr"))[[1]]
extractQSO(x)
}
\references{
Kuo-Chen Chou. Prediction of Protein Subcellar Locations by
Incorporating Quasi-Sequence-Order Effect.
\emph{Biochemical and Biophysical Research Communications},
2000, 278, 477-483.

Kuo-Chen Chou and Yu-Dong Cai. Prediction of Protein Sucellular Locations by
GO-FunD-PseAA Predictor.
\emph{Biochemical and Biophysical Research Communications},
2004, 320, 1236-1239.

Gisbert Schneider and Paul Wrede. The Rational Design of
Amino Acid Sequences by Artifical Neural Networks and Simulated
Molecular Evolution: Do Novo Design of an Idealized Leader Cleavge Site.
\emph{Biophys Journal}, 1994, 66, 335-344.
}
\seealso{
See \code{\link{extractSOCN}} for sequence-order-coupling numbers.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{QSO}
\keyword{extract}
