% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize}
\alias{bokeh}
\alias{bucket}
\alias{cytescape}
\alias{dendrogram}
\alias{pca}
\alias{prism}
\alias{slate}
\alias{smear}
\alias{snapshot}
\alias{visualize}
\title{Visualize Proportionality}
\usage{
smear(rho, prompt = TRUE, plotly = FALSE)

dendrogram(rho, prompt = TRUE, plotly = FALSE)

slate(rho, k, prompt = TRUE, plotly = FALSE)

bucket(rho, group, k, prompt = TRUE, plotly = FALSE)

prism(rho, k, prompt = TRUE, plotly = FALSE)

bokeh(rho, k, prompt = TRUE, plotly = FALSE)

pca(rho, group, prompt = TRUE, plotly = FALSE)

snapshot(rho, prompt = TRUE, plotly = FALSE)

cytescape(object, minPairs = 2)
}
\arguments{
\item{prompt}{A logical scalar. Set to \code{FALSE} to disable
the courtesy prompt when working with big data.}

\item{plotly}{A logical scalar. Set to \code{TRUE} to produce
a dynamic plot using the \code{plotly} package.}

\item{k}{A numeric scalar. The number of clusters. Optional
parameter for \code{bucket}, \code{prism}, and \code{bokeh}.
Providing the argument \code{k} will color feature pairs
by co-cluster membership. In other words, a feature pair
will receive a color if and only if both features belong
to same the cluster (calculated using \code{hclust}).}

\item{group}{A character vector. Group or sub-group memberships,
ordered according to the row names in \code{@counts} and
\code{@logratio}. Required parameter for \code{bucket}
and optional parameter for \code{pca}.}

\item{object, rho}{A \code{propr} object created from \code{perb}.
However, \code{smear}, \code{dendrogram}, and \code{cytescape} will
also accommodate results from \code{phit} and \code{phis}.}

\item{minPairs}{An integer scalar. Subsets the interaction
network to exclude any pair without a node that participates
in at least this many total pairs. Required parameter
for \code{cytescape}.}
}
\value{
\code{smear, pca:}
 Returns a \code{ggplot} object.

\code{dendrogram, snapshot:}
 Returns a \code{dendrogram} object.

\code{slate:}
 Returns a \code{data.frame} of all pairwise relationships.
 If the argument \code{k} is provided, returns a list of
 the \code{data.frame} of pairwise relationships and the
 cluster membership.

\code{prism, bokeh, bucket:}
 Returns cluster membership if \code{k} is provided.
 Otherwise, returns a \code{ggplot} object.

\code{cytescape:}
 Returns a \code{data.frame} of indexed pairs.
}
\description{
\code{smear:}
 Plots log-ratio transformed abundances pairwise.
 Index-aware, meaning that it only plots pairs indexed
 in \code{@pairs}, unless no pairs are indexed.

\code{dendrogram:}
 Plots a clustering of proportionality matrix.
 Index-aware, meaning that it only plots pairs indexed
 in \code{@pairs}, unless no pairs are indexed.
 Heatmap intensity is not scaled.

\code{slate:}
 Builds a table of VLR, VLS, and proportionality
 for each feature pair in a \code{propr} object. If the
 argument \code{k} is provided, the table will also
 include co-cluster membership.

\code{prism:}
 Plots the variance of the ratio of the log-ratio transformed
 feature pair (VLR) versus the sum of the individual variances
 of each log-ratio transformed feature (VLS). The ratio of
 the VLR to the VLS equals \code{1 - rho}. As such, we use
 here seven rainbow colored lines to indicate where \code{rho}
 equals \code{[.01, .05, .50, 0, 1.50, 1.95, 1.99]}, going
 from red to violet.

\code{bokeh:}
 Plots the feature variances for each log-ratio transformed
 feature pair in the \code{propr} object. Highly proportional
 pairs will aggregate near the \code{y = x} diagonal.
 Clusters that appear toward the top-right of the
 figure contain features with highly variable abundance across
 all samples. Clusters that appear toward the
 bottom-left of the figure contain features with fixed
 abundance across all samples. Uses a log scale.

\code{bucket:}
 Plots an estimation of the degree to which a feature pair
 differentiates the experimental groups versus the
 measure of the proportionality between that feature pair.
 "It's pronounced, 'bouquet'." - Hyacinth Bucket

\code{pca:}
 Plots the first two principal components as calculated
 using the log-ratio transformed feature vectors. This
 provides a statistically valid alternative to
 conventional principal components analysis (PCA).
 For more information, see <DOI:10.1139/cjm-2015-0821>.

\code{snapshot:}
 Plots the log-ratio transformed feature abundance as
 a heatmap, along with the respective dendrograms.
 Heatmap intensity is not scaled.

\code{cytescape:}
 Builds a table of indexed pairs and proportionality.
 In doing so, this function displays a preview of the
 interaction network, built using \code{igraph}.
 We recommend using the result as input to a
 network visualization tool like Cytoscape.
}

