% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/121.ConfidenceIntervals_CC_n.R
\name{ciCAll}
\alias{ciCAll}
\title{CI estimation of 5 continuity corrected methods (Wald, Wald-T, Score, Logit-Wald, ArcSine)}
\usage{
ciCAll(n, alp, c)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{c}{- Continuity correction}
}
\value{
A dataframe with
 \item{method }{- Name of the method}
 \item{x }{- Number of successes (positive samples)}
 \item{LLT }{ - Lower limit}
 \item{ULT }{ - Upper Limit}
 \item{LABB }{ - Lower Abberation}
 \item{UABB }{ - Upper Abberation}
 \item{ZWI }{ - Zero Width Interval}
}
\description{
CI estimation of 5 continuity corrected methods (Wald, Wald-T, Score, Logit-Wald, ArcSine)
}
\details{
The Confidence Interval on 5 continuity corrected methods (Wald, Wald-T, Score, Logit-Wald, ArcSine) for \code{n} given \code{alp} along with Continuity correction \code{c}
}
\examples{
n=5; alp=0.05;c=1/(2*n)
ciCAll(n,alp,c)
}
\references{
[1] 1998 Agresti A and Coull BA.
Approximate is better than "Exact" for interval estimation of binomial proportions.
The American Statistician: 52; 119 - 126.

[2] 1998 Newcombe RG.
Two-sided confidence intervals for the single proportion: Comparison of seven methods.
Statistics in Medicine: 17; 857 - 872.

[3] 2008 Pires, A.M., Amado, C.
Interval Estimators for a Binomial Proportion: Comparison of Twenty Methods.
REVSTAT - Statistical Journal, 6, 165-197.
}
\seealso{
\code{\link{prop.test} and \link{binom.test}} for equivalent base Stats R functionality,
   \code{\link[binom]{binom.confint}}  provides similar functionality for 11 methods,
   \code{\link[PropCIs]{wald2ci}} which provides multiple functions for CI calculation ,
   \code{\link[BlakerCI]{binom.blaker.limits}} which calculates Blaker CI which is not covered here and
   \code{\link[prevalence]{propCI}} which provides similar functionality.

Other Continuity correction methods of CI estimation: \code{\link{PlotciCAS}},
  \code{\link{PlotciCAllg}}, \code{\link{PlotciCAll}},
  \code{\link{PlotciCLT}}, \code{\link{PlotciCSC}},
  \code{\link{PlotciCTW}}, \code{\link{PlotciCWD}},
  \code{\link{ciCAS}}, \code{\link{ciCLT}},
  \code{\link{ciCSC}}, \code{\link{ciCTW}},
  \code{\link{ciCWD}}
}

