% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{project}
\alias{project}
\title{Projection onto submodel(s)}
\usage{
project(
  object,
  nterms = NULL,
  solution_terms = predictor_terms,
  predictor_terms = NULL,
  refit_prj = TRUE,
  ndraws = 400,
  nclusters = NULL,
  seed = NA,
  verbose = getOption("projpred.verbose_project", TRUE),
  ...
)
}
\arguments{
\item{object}{An object which can be used as input to \code{\link[=get_refmodel]{get_refmodel()}} (in
particular, objects of class \code{refmodel}).}

\item{nterms}{Only relevant if \code{object} is of class \code{vsel} (returned by
\code{\link[=varsel]{varsel()}} or \code{\link[=cv_varsel]{cv_varsel()}}). Ignored if \code{!is.null(predictor_terms)}.
Number of terms for the submodel (the corresponding combination of
predictor terms is taken from \code{object}). If a numeric vector, then the
projection is performed for each element of this vector. If \code{NULL} (and
\code{is.null(predictor_terms)}), then the value suggested by \code{\link[=suggest_size]{suggest_size()}}
is taken (with default arguments for \code{\link[=suggest_size]{suggest_size()}}, implying that this
suggested size is based on the ELPD). Note that \code{nterms} does not count the
intercept, so use \code{nterms = 0} for the intercept-only model.}

\item{solution_terms}{Deprecated. Please use argument \code{predictor_terms}
instead.}

\item{predictor_terms}{If not \code{NULL}, then this needs to be a character
vector of predictor terms for the submodel onto which the projection will
be performed. Argument \code{nterms} is ignored in that case. For an \code{object}
which is not of class \code{vsel}, \code{predictor_terms} must not be \code{NULL}.}

\item{refit_prj}{A single logical value indicating whether to fit the
submodels (again) (\code{TRUE}) or---if \code{object} is of class \code{vsel}---to re-use
the submodel fits from the full-data search that was run when creating
\code{object} (\code{FALSE}). For an \code{object} which is not of class \code{vsel},
\code{refit_prj} must be \code{TRUE}. See also section "Details" below.}

\item{ndraws}{Only relevant if \code{refit_prj} is \code{TRUE}. Number of posterior
draws to be projected. Ignored if \code{nclusters} is not \code{NULL} or if the
reference model is of class \code{datafit} (in which case one cluster is used).
If both (\code{nclusters} and \code{ndraws}) are \code{NULL}, the number of posterior
draws from the reference model is used for \code{ndraws}. See also section
"Details" below.}

\item{nclusters}{Only relevant if \code{refit_prj} is \code{TRUE}. Number of clusters
of posterior draws to be projected. Ignored if the reference model is of
class \code{datafit} (in which case one cluster is used). For the meaning of
\code{NULL}, see argument \code{ndraws}. See also section "Details" below.}

\item{seed}{Pseudorandom number generation (PRNG) seed by which the same
results can be obtained again if needed. Passed to argument \code{seed} of
\code{\link[=set.seed]{set.seed()}}, but can also be \code{NA} to not call \code{\link[=set.seed]{set.seed()}} at all. If not
\code{NA}, then the PRNG state is reset (to the state before calling
\code{\link[=project]{project()}}) upon exiting \code{\link[=project]{project()}}. Here, \code{seed} is used for clustering
the reference model's posterior draws (if \code{!is.null(nclusters)}) and for
drawing new group-level effects when predicting from a multilevel submodel
(however, not yet in case of a GAMM) and having global option
\code{projpred.mlvl_pred_new} set to \code{TRUE}. (Such a prediction takes place when
calculating output elements \code{dis} and \code{ce}.)}

\item{verbose}{A single logical value indicating whether to print out
additional information during the computations. More precisely, this gets
passed as \code{verbose_divmin} to the divergence minimizer function of the
\code{refmodel} object. For the built-in divergence minimizers, this only has an
effect in case of sequential computations (not in case of parallel
projection, which is described in \link{projpred-package}).}

\item{...}{Arguments passed to \code{\link[=get_refmodel]{get_refmodel()}} (if \code{\link[=get_refmodel]{get_refmodel()}} is
actually used; see argument \code{object}) as well as to the divergence
minimizer (if \code{refit_prj} is \code{TRUE}).}
}
\value{
If the projection is performed onto a single submodel (i.e.,
\code{length(nterms) == 1 || !is.null(predictor_terms)}), an object of class
\code{projection} which is a \code{list} containing the following elements:
\describe{
\item{\code{dis}}{Projected draws for the dispersion parameter.}
\item{\code{ce}}{The cross-entropy part of the Kullback-Leibler (KL)
divergence from the reference model to the submodel. For some families,
this is not the actual cross-entropy, but a reduced one where terms which
would cancel out when calculating the KL divergence have been dropped. In
case of the Gaussian family, that reduced cross-entropy is further
modified, yielding merely a proxy.}
\item{\code{wdraws_prj}}{Weights for the projected draws.}
\item{\code{predictor_terms}}{A character vector of the submodel's predictor
terms.}
\item{\code{outdmin}}{A \code{list} containing the submodel fits (one fit per
projected draw). This is the same as the return value of the
\code{div_minimizer} function (see \code{\link[=init_refmodel]{init_refmodel()}}), except if \code{\link[=project]{project()}}
was used with an \code{object} of class \code{vsel} based on an L1 search as well
as with \code{refit_prj = FALSE}, in which case this is the output from an
internal \emph{L1-penalized} divergence minimizer.}
\item{\code{cl_ref}}{A numeric vector of length equal to the number of
posterior draws in the reference model, containing the cluster indices of
these draws.}
\item{\code{wdraws_ref}}{A numeric vector of length equal to the number of
posterior draws in the reference model, giving the weights of these
draws. These weights should be treated as not being normalized (i.e.,
they don't necessarily sum to \code{1}).}
\item{\code{const_wdraws_prj}}{A single logical value indicating whether the
projected draws have constant weights (\code{TRUE}) or not (\code{FALSE}).}
\item{\code{refmodel}}{The reference model object.}
}
If the projection is performed onto more than one submodel, the output from
above is returned for each submodel, giving a \code{list} with one element for
each submodel.

The elements of an object of class \code{projection} are not meant to be
accessed directly but instead via helper functions (see the main vignette
and \link{projpred-package}; see also \code{\link[=as_draws_matrix.projection]{as_draws_matrix.projection()}}, argument
\code{return_draws_matrix} of \code{\link[=proj_linpred]{proj_linpred()}}, and argument
\code{nresample_clusters} of \code{\link[=proj_predict]{proj_predict()}} for the intended use of the
weights stored in element \code{wdraws_prj}).
}
\description{
Project the posterior of the reference model onto the parameter space of a
single submodel consisting of a specific combination of predictor terms or
(after variable selection) onto the parameter space of a single or multiple
submodels of specific sizes.
}
\details{
Arguments \code{ndraws} and \code{nclusters} are automatically truncated at
the number of posterior draws in the reference model (which is \code{1} for
\code{datafit}s). Using less draws or clusters in \code{ndraws} or \code{nclusters} than
posterior draws in the reference model may result in slightly inaccurate
projection performance. Increasing these arguments affects the computation
time linearly.

If \code{refit_prj = FALSE} (which is only possible if \code{object} is of class
\code{vsel}), \code{\link[=project]{project()}} retrieves the submodel fits from the full-data search
that was run when creating \code{object}. Usually, the search relies on a rather
coarse clustering or thinning of the reference model's posterior draws (by
default, \code{\link[=varsel]{varsel()}} and \code{\link[=cv_varsel]{cv_varsel()}} use \code{nclusters = 20}). Consequently,
\code{\link[=project]{project()}} with \code{refit_prj = FALSE} then inherits this coarse clustering
or thinning.
}
\examples{
\dontshow{if (requireNamespace("rstanarm", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Data:
dat_gauss <- data.frame(y = df_gaussian$y, df_gaussian$x)

# The `stanreg` fit which will be used as the reference model (with small
# values for `chains` and `iter`, but only for technical reasons in this
# example; this is not recommended in general):
fit <- rstanarm::stan_glm(
  y ~ X1 + X2 + X3 + X4 + X5, family = gaussian(), data = dat_gauss,
  QR = TRUE, chains = 2, iter = 500, refresh = 0, seed = 9876
)

# Run varsel() (here without cross-validation, with L1 search, and with small
# values for `nterms_max` and `nclusters_pred`, but only for the sake of
# speed in this example; this is not recommended in general):
vs <- varsel(fit, method = "L1", nterms_max = 3, nclusters_pred = 10,
             seed = 5555)

# Projection onto the best submodel with 2 predictor terms (with a small
# value for `nclusters`, but only for the sake of speed in this example;
# this is not recommended in general):
prj_from_vs <- project(vs, nterms = 2, nclusters = 10, seed = 9182)

# Projection onto an arbitrary combination of predictor terms (with a small
# value for `nclusters`, but only for the sake of speed in this example;
# this is not recommended in general):
prj <- project(fit, predictor_terms = c("X1", "X3", "X5"), nclusters = 10,
               seed = 9182)
\dontshow{\}) # examplesIf}
}
