% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-projects_stage.R
\docType{class}
\name{projects_stage-class}
\alias{projects_stage-class}
\alias{new_projects_stage}
\alias{as.integer.projects_stage}
\alias{as.double.projects_stage}
\alias{as.numeric.projects_stage}
\alias{match.projects_stage}
\alias{match,projects_stage,ANY-method}
\alias{match,ANY,projects_stage-method}
\alias{\%in\%.projects_stage}
\alias{\%in\%,projects_stage,ANY-method}
\alias{\%in\%,ANY,projects_stage-method}
\title{\code{projects_stage} class and its methods}
\usage{
new_projects_stage(x = character())

\method{as.integer}{projects_stage}(x, ...)

\method{as.double}{projects_stage}(x, ...)

\method{as.numeric}{projects_stage}(x, ...)

match.projects_stage(x, table, nomatch = NA_integer_,
  incomparables = NULL)

\S4method{match}{projects_stage,ANY}(x, table, nomatch = NA_integer_,
  incomparables = NULL)

\S4method{match}{ANY,projects_stage}(x, table, nomatch = NA_integer_,
  incomparables = NULL)

"\%in\%.projects_stage"(x, table)

\S4method{\%in\%}{projects_stage,ANY}(x, table)

\S4method{\%in\%}{ANY,projects_stage}(x, table)
}
\arguments{
\item{x}{For \code{new_projects_stage()}, any object. For

  For the \code{as.*()} methods, a \code{projects_stage} object.

  For \code{\link{match}()} and \code{\link{\%in\%}}, an integer, a character
  string, or a \code{projects_author} object. See \code{\link{match}()} and
  \strong{Comparison and value matching methods} below.}

\item{...}{further arguments passed to or from other methods.}

\item{table}{An integer number, a character string, or a
\code{projects_author} object. See \code{\link{match}()} and
\strong{Comparison and value matching methods} below.}

\item{nomatch}{See \code{\link{match}()}.}

\item{incomparables}{An integer number, a character string, or a
\code{projects_author} object. See \code{\link{match}()}.}
}
\description{
Objects of this class are merely a character string containing a number and a
name of one of seven project development stages.
}
\details{
A \code{projects_stage} object is either a missing value (\code{NA}) or one
of:

\code{0: idea}\cr \code{1: design}\cr \code{2: data collection}\cr \code{3:
analysis}\cr \code{4: manuscript}\cr \code{5: under review}\cr \code{6:
accepted}

\code{new_projects_stage()} merely coerces the object's class attribute to
\code{projects_stage}.
}
\section{Numeric coercion methods}{
 \code{\link{as.integer}()},
  \code{\link{as.double}()}, and \code{\link{as.numeric}()} return the stage
  number of the \code{projects_author} object as an integer/double. The
  methods for the comparison and value matching functions described below
  make use of these numeric coercion methods. Users desiring to apply value
  matching functions other than the ones described below may similarly take
  advantage of these.
}

\section{Comparison and value matching methods}{
 Methods for the
  \link{Comparison} operators as well as \code{\link{match}()} and
  \code{\link{\%in\%}} enable users to test equality and to value match among
  \code{projects_stage} objects and as well as between \code{projects_stage}
  objects and unclassed numbers/characters. When comparing or value matching
  against a numeric vector, the \code{projects_stage} object is first coerced
  to an integer with the \code{as.integer()} method described above. When
  testing or value matching against a character vector, the character vector
  is validated against the list of project stages enumerated above.
}

\section{\code{c()} method}{
 A method for \code{\link{c}()} was also written
  so that the class attribute is not lost.
}

\examples{
stage <- new_projects_stage("4: manuscript")

as.integer(stage) # 4

stage == 4       # TRUE
stage != 4       # FALSE
stage <  6       # TRUE

stage \%in\% c(3:6)  # TRUE
match(stage, 0:4)  # 5

stage \%in\% c("design", "manusc", "idea")  # TRUE

more_stages <- new_projects_stage(c("0: idea", "4: manuscript", "1: design"))

match("MAnuscRIPT", more_stages)      # 2

x <- structure("7: redacted", class = "dummyclass")
class(c(x))     # Does not retain class
class(c(stage, more_stages)) # Retains class
}
\seealso{
\code{\link{Ops}}; \code{\link[methods]{Methods_for_Nongenerics}}.
  For other S3 class-retention strategies, see \code{\link{Extract}} and
  \code{\link{[.data.frame}}.
}
