% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/and.R
\name{and}
\alias{and}
\title{AND}
\usage{
and(activity_a, activity_b)
}
\arguments{
\item{activity_a}{\code{\link{character}}: Activity A. This should be an activity of the log supplied to \code{\link{check_rule}}.}

\item{activity_b}{\code{\link{character}}: Activity B. This should be an activity of the log supplied to \code{\link{check_rule}}.}
}
\description{
Check for co-existence of two activities.

The\code{and} rule checks whether two activities both occur in a case (or are both absent).
If \code{activity_a} exists, \code{activity_b} should also exist, and vice versa.
}
\examples{
library(bupaR)
library(eventdataR)

# Check that if a patients is registered, he's also checked-out, and vice versa.
patients \%>\%
 check_rule(and("Registration","Check-out"))

}
\seealso{
Other Exclusiveness rules: 
\code{\link{xor}()}
}
\concept{Exclusiveness rules}
