% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCatEquation.R
\name{makeCatEquation2}
\alias{makeCatEquation2}
\title{Make equation for sem and lm for multiple X or multiple Y}
\usage{
makeCatEquation2(
  X = NULL,
  Y = NULL,
  W = NULL,
  labels = list(),
  vars = list(),
  prefix = "b",
  mode = 0,
  pos = list(),
  serial = FALSE,
  depy = FALSE,
  depx = FALSE
)
}
\arguments{
\item{X}{Names of independent variable}

\item{Y}{Names of dependent variable}

\item{W}{Names of moderators}

\item{labels}{optional list}

\item{vars}{optional list}

\item{prefix}{a character}

\item{mode}{A numeric}

\item{pos}{Numeric moderator position}

\item{serial}{logical If TRUE, serial variables are added}

\item{depy}{logical}

\item{depx}{logical}
}
\description{
Make equation for sem and lm for multiple X or multiple Y
}
\examples{
makeCatEquation2(X="wt",Y="mpg")
makeCatEquation2(X="wt",Y="mpg",W="cyl")
makeCatEquation2(X="wt",Y=c("cyl","am"),prefix="a")
makeCatEquation2(X="wt",Y=c("hp","vs"),W="cyl",prefix="a")
makeCatEquation2(X="wt",Y=c("hp","vs"),W=c("cyl","am"),prefix="a",pos=list(1,2))
makeCatEquation2(X="wt",Y=c("hp","vs"),W=c("cyl"),prefix="a",pos=list(1))
makeCatEquation2(X="wt",Y=c("hp","vs"),W=c("cyl"),prefix="a",pos=list(c(1,2)))
makeCatEquation2(X=c("hp","vs"),Y="mpg",W=c("cyl"),prefix="b",pos=list(c(1)))
makeCatEquation2(X=c("hp","vs"),Y="mpg",W=c("cyl"),prefix="b")
makeCatEquation2(X=c("hp","vs"),Y="mpg",W=c("cyl"),prefix="b",pos=list(c(1,2)))
cat(makeCatEquation2(X="wt",Y="carb",W=c("am","hp")))
cat(makeCatEquation2(X="X",Y=c("M1","M2","M3"),W=NULL,prefix="a",serial=TRUE))
cat(makeCatEquation2(X="X",Y=c("M1","M2","M3"),W=NULL,prefix="a"))
cat(makeCatEquation2(X="X",Y=c("M1","M2"),prefix="a",mode=1,serial=TRUE))
}
