% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-blindness.R
\name{clr_protan}
\alias{clr_protan}
\alias{clr_deutan}
\alias{clr_tritan}
\title{Simulate color vision deficiency}
\source{
\url{http://www.inf.ufrgs.br/~oliveira/pubs_files/CVD_Simulation/CVD_Simulation.html}
}
\usage{
clr_protan(col, severity = 1)

clr_deutan(col, severity = 1)

clr_tritan(col, severity = 1)
}
\arguments{
\item{col}{a color object or vector of any of the three kinds of R color
specifications, i.e., either a color name (as listed by colors()), a
hexadecimal string of the form "#rrggbb" or "#rrggbbaa" (see rgb), or a
positive integer i meaning palette()[i].}

\item{severity}{A numeric, Severity of the color vision defect, a number
between 0 and 1. 0 means no deficiency, 1 means complete deficiency. Defaults
 to 1.}
}
\value{
a colors object of same length as col.
}
\description{
Simulate color vision deficiency
}
\details{
The matrices uses to perform transformations have been taken as the
 1.0 value in table 1 in \url{http://www.inf.ufrgs.br/~oliveira/pubs_files/CVD_Simulation/CVD_Simulation.html}.
}
\examples{
rainbow_colors <- color(rainbow(10))

plot(clr_protan(rainbow_colors))
plot(clr_deutan(rainbow_colors))
plot(clr_tritan(rainbow_colors))

viridis_colors <- c(
  "#4B0055FF", "#422C70FF", "#185086FF", "#007094FF",
  "#008E98FF", "#00A890FF", "#00BE7DFF", "#6CD05EFF",
  "#BBDD38FF", "#FDE333FF"
)

plot(clr_protan(viridis_colors))
plot(clr_deutan(viridis_colors))
plot(clr_tritan(viridis_colors))
}
\references{
Gustavo M. Machado, Manuel M. Oliveira, and Leandro A. F. Fernandes "A
 Physiologically-based Model for Simulation of Color Vision Deficiency". IEEE
 Transactions on Visualization and Computer Graphics. Volume 15 (2009),
 Number 6, November/December 2009. pp. 1291-1298.
}
