% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_for_inflation.R
\name{retrieve_inflation_data}
\alias{retrieve_inflation_data}
\title{Retrieve historical inflation data}
\usage{
retrieve_inflation_data(country, countries_dataframe)
}
\arguments{
\item{country}{A country_name or iso2code (see show_countries() for complete list of available inputs).}

\item{countries_dataframe}{The output from show_countries(). It is optional, but if not provided, it will be retrieved via the API.}
}
\value{
A data.frame containing inflation data from World Bank API for specified country
}
\description{
Retrieve inflation data for any country/region (using iso2Code or country_name)
}
\examples{
\dontrun{
# Retrieve inflation data for any country (or iso2Code)
country <- "AU"
inflation_dataframe <- retrieve_inflation_data(country)

country <- "Australia"
countries_dataframe <- show_countries()
inflation_dataframe <- retrieve_inflation_data(country, countries_dataframe)
}
# inflation_dataframe
#    indicator.id                       indicator.value country.id country.value     value
#  FP.CPI.TOTL.ZG Inflation, consumer prices (annual \%)         AU     Australia      <NA>
#  FP.CPI.TOTL.ZG Inflation, consumer prices (annual \%)         AU     Australia   1.94864
#  FP.CPI.TOTL.ZG Inflation, consumer prices (annual \%)         AU     Australia   1.27699
#  FP.CPI.TOTL.ZG Inflation, consumer prices (annual \%)         AU     Australia   1.50836
#  Etc


}
