% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bisection.R
\name{bisection}
\alias{bisection}
\title{Bisection algorithm for bootstrap calibration of prediction intervals}
\usage{
bisection(
  y_star_hat,
  pred_se,
  y_star,
  alternative,
  quant_min,
  quant_max,
  n_bisec,
  tol,
  alpha,
  traceplot = TRUE
)
}
\arguments{
\item{y_star_hat}{a list of length \eqn{B} that contains the expected future observations.
Each entry in this list has to be a numeric vector of length \eqn{M}.}

\item{pred_se}{a list of length \eqn{B} that contains the standard errors of the prediction.
Each entry in this list has to be a numeric vector of length \eqn{M}.}

\item{y_star}{a list of length \eqn{B} that contains the future observations.
Each entry in this list has to be a numeric vector of length \eqn{M}.}

\item{alternative}{either "both", "upper" or "lower".
\code{alternative} specifies if a prediction interval or
an upper or a lower prediction limit should be computed}

\item{quant_min}{lower start value for bisection}

\item{quant_max}{upper start value for bisection}

\item{n_bisec}{maximal number of bisection steps}

\item{tol}{tolerance for the coverage probability in the bisection}

\item{alpha}{defines the level of confidence (\eqn{1-\alpha})}

\item{traceplot}{if \code{TRUE}: Plot for visualization of the bisection process}
}
\value{
This function returns \eqn{q^{calib}} in the equation above.
}
\description{
This helper function returns a bootstrap calibrated coefficient for the calculation
of prediction intervals (and limits).
}
\details{
This function is an implementation of the bisection algorithm of Menssen
and Schaarschmidt 2022. It returns a calibrated coefficient \eqn{q^{calib}} for the
calculation of simultaneous prediction intervals (or limits)
\deqn{[l,u] = \hat{y}^*_m  \pm q^{calib} \hat{se}(Y_m - y^*_m)}
that cover all of \eqn{m=1, ... , M} future observations. \cr

In this notation, \eqn{\hat{y}^*_m} are the expected future observations for each of
the \eqn{m} future clusters, \eqn{q^{calib}} is the
calibrated coefficient and \eqn{\hat{se}(Y_m - y^*_m)}
are the standard errors of the prediction. \cr
}
\references{
Menssen and Schaarschmidt (2022): Prediction intervals for all of M future
observations based on linear random effects models. Statistica Neerlandica. \cr
 \doi{10.1111/stan.12260}
}
