% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_data.R
\name{find_data}
\alias{find_data}
\title{Extract data from a model object}
\usage{
find_data(model, env = parent.frame())
}
\arguments{
\item{model}{The model object.}

\item{env}{An environment in which to look for the \code{data} argument to the modelling call.}
}
\value{
A data.frame, typically with one column unless the variable is a factor with more than two levels.
}
\description{
Find a model frame in a model object or try to reconstruct one
}
\examples{
require("datasets")
x <- lm(mpg ~ cyl * hp + wt, data = head(mtcars))
find_data(x)

}
\seealso{
\code{\link{prediction}}
}

