% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nmb_sampler.R
\name{get_nmb_sampler}
\alias{get_nmb_sampler}
\title{Make a NMB sampler (an R function) for use in \code{do_nmb_sim()} or
\code{screen_simulation_inputs()}}
\usage{
get_nmb_sampler(
  outcome_cost,
  wtp,
  qalys_lost,
  high_risk_group_treatment_effect,
  high_risk_group_treatment_cost,
  low_risk_group_treatment_effect = 0,
  low_risk_group_treatment_cost = 0,
  use_expected_values = FALSE,
  nboot = 10000
)
}
\arguments{
\item{outcome_cost}{The cost of the outcome. Must be provided if \code{wtp}
and \code{qalys_lost} are not.
Or can be used in addition to these arguments to represent additional cost
to the health burden.}

\item{wtp}{Willingness-to-pay.}

\item{qalys_lost}{Quality-adjusted life years (QALYs) lost due to healthcare
event being predicted.}

\item{high_risk_group_treatment_effect}{The effect of the treatment provided
to patients given high risk prediction. Can be a number of a function.
Provide a function to incorporate uncertainty.}

\item{high_risk_group_treatment_cost}{The cost of the treatment provided to
patients given high risk prediction. Can be a number of a function.
Provide a function to incorporate uncertainty.}

\item{low_risk_group_treatment_effect}{The effect of the treatment provided
to patients given low risk prediction. Can be a number of a function.
Provide a function to incorporate uncertainty. Defaults to 0 (no treatment).}

\item{low_risk_group_treatment_cost}{The cost of the treatment provided to
patients given low risk prediction. Can be a number of a function.
Provide a function to incorporate uncertainty. Defaults to 0 (no treatment).}

\item{use_expected_values}{Logical. If \code{TRUE}, gets the mean of many
samples from the produced function and returns these every time. This is a
sensible choice when using the resulting function for selecting the cutpoint.
See \code{fx_nmb_training}. Defaults to \code{FALSE}.}

\item{nboot}{The number of samples to use when creating a function that
returns the expected values. Defaults to 10000.}
}
\value{
Returns a \code{function}.
}
\description{
Make a NMB sampler (an R function) for use in \code{do_nmb_sim()} or
\code{screen_simulation_inputs()}
}
\examples{
get_nmb_training <- get_nmb_sampler(
  outcome_cost = 100,
  high_risk_group_treatment_effect = function() rbeta(1, 1, 2),
  high_risk_group_treatment_cost = 10,
  use_expected_values = TRUE
)
get_nmb_evaluation <- get_nmb_sampler(
  outcome_cost = 100,
  high_risk_group_treatment_effect = function() rbeta(1, 1, 2),
  high_risk_group_treatment_cost = 10
)

get_nmb_training()
get_nmb_training()
get_nmb_training()
get_nmb_evaluation()
get_nmb_evaluation()
get_nmb_evaluation()
}
