\name{prab.sarestimate}
\alias{prab.sarestimate}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Estimates SAR model from log-abundance matrix of prab-object.}
\description{ 
  This is either an interface for the function \code{\link[spdep]{errorsarlm}}
  for abundance data stored in an object of class \code{prab}
  implemented for use in \code{abundtest}, or, in case that spatial
  information should be ignored, it estimates a two-way additive
  unreplicated linear
  model for log-abundances on factors species and region. 
}
\usage{
prab.sarestimate(abmat, prab01=NULL,sarmethod="eigen",
                             weightstyle="C",
                             quiet=TRUE, sar=TRUE,
                             add.lmobject=TRUE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{abmat}{object of class \code{prab}.}
  \item{prab01}{presence-absence matrix of same dimensions than the
  abundance matrix of \code{prabobj}. This specifies the presences and
  absences on which the presence/absence step of abundance-based tests
  is based (see details). If \code{NULL} (which is usually the only
  reasonable choice), \code{prab01} is computed in order to indicate
  the nonzeroes of \code{prabobj$prab}.}
\item{sarmethod}{this is passed on as parameter \code{method} to
  \code{\link[spdep]{errorsarlm}} and documented there. We don't have
  experience with any other choice than \code{"eigen"}.} 
  \item{weightstyle}{can take values "W", "B", "C", "U", and "S" though tests
    suggest that "C" should be chosen. See \code{\link[spdep]{nb2listw}}.} 
  \item{quiet}{this is passed on as parameter \code{quiet} to
  \code{\link[spdep]{errorsarlm}} and documented there.} 
  \item{sar}{logical. If \code{TRUE}, a simultaneous autoregression
    model is fitted by calling \code{\link[spdep]{errorsarlm}}. If
    \code{FALSE}, a two-way additive
    unreplicated linear
    model for log-abundances on factors species and region is computed
    by \code{\link[stats]{lm}},
    ignoring the spatial arrangement of the regions.} 
  \item{add.lmobject}{logical. If \code{TRUE}, the whole output object
    of \code{\link[spdep]{errorsarlm}} (or \code{lm}) is given out.} 
}
\value{
  A list with the following components:
  \item{sar}{see above.}
  \item{intercept}{numeric. Estimator of the intercept.}
  \item{sigma}{numeric. Estimator of error standard deviation.}
  \item{regeffects}{numeric vector. Estimator for region effects.}
  \item{speceffects}{numeric vector. Estimator for species effects.}
  \item{lamda}{numeric. Governs the degree of spatial
    autocorrelation. See \code{\link[spdep]{errorsarlm}}.}
  \item{size}{integer. Length of neighborhood list generated by
    \code{\link[spdep]{nb2listw}} used by
    \code{\link[spdep]{errorsarlm}}.}
  \item{nbweight}{numeric. Average weight of neighbors.}
  \item{lmobject}{if \code{add.lmobject=TRUE}, output object of either
     \code{\link[stats]{lm}} or \code{\link[spdep]{errorsarlm}}.}
}

\author{Christian Hennig
  \email{chrish@stats.ucl.ac.uk}
  \url{http://www.homepages.ucl.ac.uk/~ucakche}}

\seealso{
  \code{\link[spdep]{errorsarlm}},
  \code{\link{abundtest}}
}

\examples{
  data(siskiyou)
  x <- prabinit(prabmatrix=siskiyou, neighborhood=siskiyou.nb,
             distance="none")
#  Not run; this needs package spdep 
#  prab.sarestimate(x)
  prab.sarestimate(x, sar=FALSE)
}
\keyword{spatial}% at least one, from doc/KEYWORDS

