% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppc_committees.R
\name{ppc_committees}
\alias{ppc_committees}
\title{Committees}
\usage{
ppc_committees(
  congress = "116",
  chamber = c("joint", "house", "senate"),
  api_key = NULL,
  raw = FALSE
)
}
\arguments{
\item{congress}{The number of Congress of interest}

\item{chamber}{Specify the chamber of Congress typically "house" or "senate";
sometimes "both" or "joint"}

\item{api_key}{The actual API key string provided by ProPublica.}

\item{raw}{Logical indicating whether to return the raw response object. The
default (FALSE) parses the content and returns a tibble data frame.}
}
\value{
A data frame of congressional committees information
}
\description{
Lists of Committees
}
\examples{
\dontrun{
## get committes info for house members in 115th congress
h115com <- ppc_committees("115", "house")
}
}
