% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest.1samp.R
\name{ttest.1samp}
\alias{ttest.1samp}
\title{Power calculation for one-sample t test}
\usage{
ttest.1samp(
  N = NULL,
  delta = NULL,
  sd = 1,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{N}{The sample size.}

\item{delta}{muA (the true mean) - mu0 (the mean under the null).}

\item{sd}{The standard deviation; defaults to 1.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two-sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
This function computes power and sample size for a one-sample t test.
Can solve for power, N, delta, sd or alpha.
}
\examples{
ttest.1samp(N = 36, delta = 4.9 - 5.7, sd = 2, sides = 1)
ttest.1samp(N = 36, delta = 6.3 - 5.7, sd = 2, sides = 1)
ttest.1samp(N = 36, delta = 4.9 - 5.7, sd = 2, sides = 2)
ttest.1samp(delta = 0.6, sd = 1, power = 0.8, sides = 1)
}
