% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multisite.hte.R
\name{multisite.hte}
\alias{multisite.hte}
\title{Power for test of heterogeneity of treatment effect in a multisite trial}
\usage{
multisite.hte(
  m = NULL,
  alloc.ratio = 1,
  J = NULL,
  VR = NULL,
  alpha = 0.05,
  power = NULL,
  v = FALSE
)
}
\arguments{
\item{m}{The mean number of subjects per site.}

\item{alloc.ratio}{The allocation ratio of intervention/control subjects per site; defaults to 1.}

\item{J}{The total number of sites.}

\item{VR}{The variance ratio (variance of the site-level treatment effects divided by variance of
observations within sites) under the alternative.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed power).
}
\description{
Calculates power for a test of heterogeneity of the treatment effect
in a multisite trial with a continuous outcome variable. In particular,
let sigma.u1^2 be the variance of the site-level treatment effects.
The test of heterogeneity tests the null hypothesis that sigma.u1^2 = 0
versus the alternative that sigma.u1^2 > 0.
Can solve for power, J, or m.
}
\details{
See Crespi CM (2025) for details.
}
\examples{
multisite.hte(m = 10, J = 30, VR = 8 / 36)
}
