% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{per_treatment}
\alias{per_treatment}
\title{Setup parameters that differ per treatment group}
\usage{
per_treatment(control, treatment)
}
\arguments{
\item{control}{Value used for control group}

\item{treatment}{Value used for treatment group}
}
\value{
An object of class "plcp_per_treatment"
}
\description{
Helps specifying unequal cluster sizes with \code{\link{study_parameters}},
e.g. different number of clusters in the treatment and control arm, or
different dropout patterns.
}
\details{
The type of object passed to \code{control} and \code{treatment}
will depend on the parameters in \code{\link{study_parameters}} that should
have different values per treatment group.
}
\examples{
n2 <- per_treatment(control = 10,
                    treatment = 20)
p <- study_parameters(n1 = 11,
                      n2 = n2,
                      n3 = 6,
                      T_end = 10,
                      icc_pre_subject = 0.5,
                      icc_pre_cluster = 0,
                      var_ratio = 0.03,
                      icc_slope = 0.05,
                      cohend = -0.8)
}
\seealso{
\code{\link{unequal_clusters}}, \code{\link{study_parameters}},
\code{\link{dropout_weibull}}
}
