% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmAldousBeta.R
\name{genAldousBetaTree}
\alias{genAldousBetaTree}
\title{Generation of rooted binary trees under Aldous' beta splitting model}
\usage{
genAldousBetaTree(n, BETA)
}
\arguments{
\item{n}{Integer value that specifies the desired number of leaves, i.e.,
vertices with in-degree 1 and out-degree 0.}

\item{BETA}{Numeric value >=-2 which specifies how the leaf sets
are partitioned. For certain choices of \code{BETA} the Aldous beta model
coincides with known models:\cr
\itemize{
\item \code{BETA} = 0: Yule model \cr
\item \code{BETA} = -3/2: PDA model (all phylogenies equally probable) \cr
\item \code{BETA} = -2: Caterpillar with \code{n} leaves
}}
}
\value{
\code{genAldousBetaTree} A single tree of class \code{phylo} is
returned.
}
\description{
\code{genAldousBetaTree} - Generates a rooted binary tree in
\code{phylo} format with the given number of \code{n} leaves under the
Aldous beta model.
The Aldous beta model is not a rate-based incremental evolutionary (tree)
construction and thus cannot generate edge lengths, only a topology.
Instead, the Aldous beta model works as follows: The idea is to start with
the root and the set of its descendant leaves, i.e., all \code{n} leaves.
Then, this set is partitioned into two subsets according to a density
function dependent on the parameter \code{beta}.
The two resulting subsets contain the leaves of the two maximal pending
subtrees of the root, respectively. The same procedure is then applied to the
root's children and their respective subsets, and so forth. \cr
Due to the restrictions of the \code{phylo} or \code{multiphylo} format
the number of leaves must be at least 2 since there must be at
least one edge.
}
\examples{
genAldousBetaTree(n = 5, BETA = 1)
}
\references{
\itemize{
\item D. Aldous. Probability Distributions on Cladograms. In Random Discrete
Structures, pages 1–18. Springer New York, 1996.
}
}
\author{
Sophie Kersting
}
