% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_01.R
\name{trim_01}
\alias{trim_01}
\title{Trim Values So They Are Between 0 and 1}
\usage{
trim_01(x)
}
\arguments{
\item{x}{A numeric vector. Can be an
\link[rvec:rvec]{rvec}.}
}
\value{
A trimmed version of \code{x}
}
\description{
Trim a vector so that all values are greater
than 0 and less than 1.
}
\details{
If
\itemize{
\item \code{min} is lowest element of \code{x}
that is higher than 0, and
\item \code{max} is the highest element of \code{x} that is
lower than 1,
then \code{trim_01()}
\item shifts all elements of \code{x} that are lower than \code{min}
upwards, so that they equal \code{min}, and
\item shifts all elements of \code{x} that are higher than \code{max}
downwards, so that they equal \code{max}.
}
}
\examples{
x <- c(1, 0.98, -0.001, 0.5, 0.01)
trim_01(x)
}
\seealso{
\itemize{
\item \code{\link[=logit]{logit()}}, \code{\link[=invlogit]{invlogit()}} Logit transformation
}
}
