% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_kinship.R
\name{mean_kinship}
\alias{mean_kinship}
\title{Calculate the weighted mean kinship}
\usage{
mean_kinship(kinship, weights = NULL)
}
\arguments{
\item{kinship}{The kinship matrix}

\item{weights}{Weights for individuals (optional).
If \code{NULL} (default), uniform weights are used.}
}
\value{
The weighted mean kinship matrix, equivalent to \code{ drop( weights \%*\% kinship \%*\% weights ) } for normalized weights (which sum to one).
}
\description{
This function computes a particular weighted mean kinship that arises in the context of kinship and \eqn{F_{ST}}{FST} estimators and in the definition of the effective sample size.
This function allows for weights to be zero or even negative, but they are internally normalized to sum to one.
}
\examples{
# construct a dummy kinship matrix
kinship <- matrix(c(0.5, 0, 0, 0.6), nrow=2)

# this is the ordinary mean
mean_kinship(kinship)

# weighted mean with twice as much weight on the second individual
# (weights are internally normalized to sum to one)
weights <- c(1, 2)
mean_kinship(kinship, weights)

}
