\name{geom_edgelabels}
\alias{geom_edgelabels}
\title{Plotting of a population graph edge labels using ggplot neumonic}
\usage{
geom_edgelabels(mapping = NULL, graph = NULL, directed = FALSE,
  offset = c(0, 0), ...)
}
\arguments{
  \item{mapping}{The aesthetic mapping as an \code{aes()}
  object.  This aesthetic must at least have values for x,
  y, and label}

  \item{graph}{The popgraph/igraph object to be plot}

  \item{directed}{A flag indicating that you should only
  plot the edge with the largest weight if more than one
  edge connects nodes.}

  \item{offset}{The amount added to each X,Y coordinate to
  move the label off the line (default=c(0,0)).}

  \item{...}{Options passed to \code{geom_text} like color,
  etc.}
}
\value{
A formatted geom_text object for addition to a ggplot()
}
\description{
This function allows you to layer the edgeset lables from a
\code{popgraph} object
}
\examples{
a <- matrix( c(0,1,0,1,1,0,0,1,0,0,0,1,1,1,1,0),nrow=4)
rownames(a) <- colnames(a) <- LETTERS[1:4]
graph <- as.popgraph(a)
igraph::V(graph)$x <- runif(4)
igraph::V(graph)$y <- runif(4)
igraph::E(graph)$Label <- LETTERS[1:4]
require(ggplot2)
p <- ggplot() + geom_edgeset( aes(x=x,y=y), graph )
p + geom_edgelabels(aes(x=x,y=y,label=Label),graph)
p + geom_edgelabels(aes(x=x,y=y,label=Label),graph,color="red")
p + geom_edgelabels(aes(x=x,y=y,label=Label),graph,color="red", offset=c(.005,-0.004))
}
\author{
Rodney J. Dyer <rjdyer@vcu.edu>
}

