% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poolcost_t.R
\name{poolcost_t}
\alias{poolcost_t}
\title{Visualize Total Costs for Pooling Design as a Function of Pool Size}
\usage{
poolcost_t(g = 1:10, d = 0.2, sigsq = 1, sigsq_p = 0, sigsq_m = 0,
  multiplicative = FALSE, mu = 1, alpha = 0.05, beta = 0.2,
  type = "two.sample", assay_cost = 100, other_costs = 0, labels = TRUE,
  ylim = NULL)
}
\arguments{
\item{g}{Numeric vector of pool sizes to include.}

\item{d}{Numeric value specifying true difference in group means.}

\item{sigsq}{Numeric value specifying the variance of observations.}

\item{sigsq_p}{Numeric value specifying the variance of processing errors.}

\item{sigsq_m}{Numeric value specifying the variance of measurement errors.}

\item{multiplicative}{Logical value for whether to assume multiplicative
rather than additive errors.}

\item{mu}{Numeric value specifying the larger of the two suspected means.
Only used if \code{multiplicative = TRUE}.}

\item{alpha}{Numeric value specifying significance level.}

\item{beta}{Numeric value specifying beta = 1 - power.}

\item{type}{Character string specifying type of t-test. Choices are
\code{"two.sample"}, \code{"one.sample"}, and \code{"paired"}.}

\item{assay_cost}{Numeric value specifying cost of each assay.}

\item{other_costs}{Numeric value specifying other per-subject costs.}

\item{labels}{Logical value.}

\item{ylim}{Numeric vector.}
}
\value{
Plot of total costs vs. pool size generated by
\code{\link[ggplot2]{ggplot}}.
}
\description{
Useful for determining whether pooling is a good idea, what pool size
minimizes costs, and how many assays are needed for a target power.
}
\examples{
# Plot study costs vs. pool size with default settings
poolcost_t()

# Add processing error and other per-subject costs
poolcost_t(sigsq_p = 0.2, other_costs = 0.1)


}
