% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logreg_xerrors.R
\name{logreg_xerrors}
\alias{logreg_xerrors}
\title{Logistic Regression with Normal Exposure Subject to Errors}
\usage{
logreg_xerrors(y, xtilde, c = NULL, prev = NULL, samp_y1y0 = NULL,
  merror = TRUE, approx_integral = TRUE, integrate_tol = 1e-08,
  integrate_tol_start = integrate_tol,
  integrate_tol_hessian = integrate_tol, estimate_var = TRUE, ...)
}
\arguments{
\item{y}{Numeric vector of \code{Y} values.}

\item{xtilde}{List of numeric vectors with \code{Xtilde} values.}

\item{c}{Numeric matrix with \strong{\code{C}} values (if any), with
one row for each pool. Can be a vector if there is only 1 covariate.}

\item{prev}{Numeric value specifying disease prevalence, allowing for valid
estimation of the intercept with case-control sampling. Can specify
\code{samp_y1y0} instead if sampling rates are known.}

\item{samp_y1y0}{Numeric vector of length 2 specifying sampling probabilities
for cases and controls, allowing for valid estimation of the intercept with
case-control sampling. Can specify \code{prev} instead if it's easier.}

\item{merror}{Logical value for whether there is measurement error.}

\item{approx_integral}{Logical value for whether to use the probit
approximation for the logistic-normal integral, to avoid numerically
integrating \code{X}'s out of the likelihood function.}

\item{integrate_tol}{Numeric value specifying the \code{tol} input to
\code{\link{adaptIntegrate}}. Only used if \code{approx_integral = FALSE}.}

\item{integrate_tol_start}{Same as \code{integrate_tol}, but applies only to
the very first iteration of ML maximization. The first iteration tends to
take much longer than subsequent ones, so less precise integration at the
start can speed things up.}

\item{integrate_tol_hessian}{Same as \code{integrate_tol}, but for use when
estimating the Hessian matrix only. Sometimes more precise integration
(i.e. smaller tolerance) than used for maximizing the likelihood helps
prevent cases where the inverse Hessian is not positive definite.}

\item{estimate_var}{Logical value for whether to return variance-covariance
matrix for parameter estimates.}

\item{...}{Additional arguments to pass to \code{\link[stats]{nlminb}}.}
}
\value{
List containing:
\enumerate{
\item Numeric vector of parameter estimates.
\item Variance-covariance matrix (if \code{estimate_var = TRUE}).
\item Returned \code{\link[stats]{nlminb}} object from maximizing the
log-likelihood function.
\item Akaike information criterion (AIC).
}
}
\description{
Assumes exposure measurements are subject to additive normal measurement
error, and exposure given covariates is a normal-errors linear regression.
Some replicates are required for identifiability.
}
\examples{
# Load dataset - dat1 has (Y, C) values and dat1_xtilde is list with 1 or 2
# Xtilde measurements for each subject.
data(dat1)
data(dat1_xtilde)

# Estimate log-OR for X and Y adjusted for C, ignoring measurement error
fit1 <- logreg_xerrors(y = dat1$y, xtilde = dat1_xtilde, c = dat1$c,
                       merror = FALSE)
fit1$theta.hat

# Repeat, but accounting for measurement error. Closer to true log-OR of 0.5.
fit2 <- logreg_xerrors(y = dat1$y, xtilde = dat1_xtilde, c = dat1$c,
                       merror = TRUE)
fit2$theta.hat


}
