% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.builder.R
\name{graph.builder}
\alias{graph.builder}
\title{Implement a graph builder heuristic by successively adding leaves to an initial graph}
\usage{
graph.builder(
  x,
  leaves.to.add,
  fstats,
  heap.dbic = 6,
  max.heap.size = 25,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{An object (or list of objects) of class graph.params or fitted.graph (see details)}

\item{leaves.to.add}{Names of the leaves to successively add (in the given order)}

\item{fstats}{Object of class fstats that contains estimates of the fstats (see compute.fstats)}

\item{heap.dbic}{Maximal BIC distance from the best graph to be kept in the heap (heap.dbic=6 by default)}

\item{max.heap.size}{Maximal number of graphs stored in the heap (max.heap.size=25 by default)}

\item{verbose}{If TRUE extra information is printed on the terminal}

\item{...}{Some parameters to be passed the function add.leaf called internally}
}
\value{
A list with the following elements:
\enumerate{
\item "n.graphs": The final number of fitted graphs
\item "fitted.graphs.list": a list of fitted.graph objects (indexed from 1 to n.graphs and in the same order as the list "graphs") containing the results of fitting of each graph. 
\item "best.fitted.graph": The graph (object of class fitted.graph) with the minimal BIC (see function fit.graph) among all the graphs within fitted.graphs.list 
\item "bic": a vector of the n.graphs BIC (indexed from 1 to n.graphs and in the same order as the "fitted.graphs.list" list) (see fit.graph details for the computation of the scores). 
}
}
\description{
Implement a graph builder heuristic by successively adding leaves to an initial graph
}
\details{
The input object x needs to be of class graph.params as generated by the function generate.graph.params; or fitted.graph as generated by the functions fit.graph, add.leaf (in the output list element named "fitted.graphs.list") or rooted.nj.builder (in the output element named "best.rooted.tree"). This is to ensure that the matrix describing the structure of the graph (graph slot of these objects) is valid (note that it can be plotted for checks). Hence graph.params objects may have been generated without fstats information (that should be supplied independently to the add.leaf function to obtain information on the fstats involving the candidate leaf defined with the leaf.to.add argument).
The functions successively add each leaf given in the leaves.to.add vector to the list of fitted graph stored in a heap using the function add.leaf. For the first iteration (i.e., first tested leaf) the heap consists of the input graph or list of graph x. At each iteration, the function add.leaf is used to test the candidate leaf to each graph from the current heap in turn. A new heap of graphs is then built by each time including the fitted graphs with a BIC less than heap.dbic larger than the best resulting graphs (treating each graph independently). If the final number of graphs in the heap is larger than max.heap.size, the max.heap.size graphs with the lowest BIC are kept in the heap. After testing the latest leaf, graphs with a BIC larger than heap.dbic units of the best graph are discarded from the final list of graphs.
In practice, it is recommended to test different orders of inclusion of the leaves (as specified in the vector leaves.to.add)
}
\seealso{
see \code{\link{fit.graph}}, \code{\link{generate.graph.params}} and \code{\link{add.leaf}}.
}
