% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_import.R
\name{indexSNPs}
\alias{indexSNPs}
\title{Obtain the index of SNPs inside a block with defined size}
\usage{
indexSNPs(positions, range, window)
}
\arguments{
\item{positions}{is a numeric vector where each entry corresponds to the
position of a SNP present in the contig.}

\item{range}{is a numeric vector with two entries: the first is the minimum
position of any SNP of the contig and the second is the maximum position of
any SNP in that same contig.}

\item{window}{is a non-negative integer indicating the size, in base pairs,
of the block of the contig to keep.}
}
\value{
a numeric vector containing the index of the SNPs present within a
randomly selected window of a given contig.
}
\description{
Selects a random block of a smaller size from a larger contig and obtain the
index of the SNPs that are contained within that block.
}
\details{
This function starts by removing the edges of the contig. The size of the
removed portion is equal to the size of the block to keep. Then, a SNP is
randomly pick from the vector of all possible SNP positions. An initial block
is constructed by selecting all SNPs contained in a window of \code{window}
size, both upstream and downstream from that SNP. Finally, SNPs are removed
from both ends of that initial block until all remaining SNPs are contained
within a block of \code{window} size.
}
\keyword{internal}
