% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{proj_grad_kde_polysph}
\alias{proj_grad_kde_polysph}
\title{Projected gradient of the polyspherical kernel density estimator}
\usage{
proj_grad_kde_polysph(x, X, d, h, weights = as.numeric(c()),
  wrt_unif = FALSE, normalized = TRUE, norm_x = FALSE, norm_X = FALSE,
  kernel = 1L, kernel_type = 1L, k = 10, proj_alt = TRUE,
  fix_u1 = TRUE, sparse = FALSE)
}
\arguments{
\item{x}{a matrix of size \code{c(nx, sum(d) + r)} with the evaluation
points.}

\item{X}{a matrix of size \code{c(n, sum(d) + r)} with the sample.}

\item{d}{vector of size \code{r} with dimensions.}

\item{h}{vector of size \code{r} with bandwidths.}

\item{weights}{weights for each observation. If provided, a vector of size
\code{n} with the weights for multiplying each kernel. If not provided,
set internally to \code{rep(1 / n, n)}, which gives the standard estimator.}

\item{wrt_unif}{flag to return a density with respect to the uniform
measure. If \code{FALSE} (default), the density is with respect to the
Lebesgue measure.}

\item{normalized}{flag to compute the normalizing constant of the kernel
and include it in the kernel density estimator. Defaults to \code{TRUE}.}

\item{norm_x, norm_X}{ensure a normalization of the data? Defaults to
\code{FALSE}.}

\item{kernel}{kernel employed: \code{1} for von Mises--Fisher (default);
\code{2} for Epanechnikov; \code{3} for softplus.}

\item{kernel_type}{type of kernel employed: \code{1} for product kernel
(default); \code{2} for spherically symmetric kernel.}

\item{k}{softplus kernel parameter. Defaults to \code{10.0}.}

\item{proj_alt}{alternative projection. Defaults to \code{TRUE}.}

\item{fix_u1}{ensure the \eqn{u_1} vector is different from \eqn{x}?
Prevents the Euler algorithm to "surf the ridge". Defaults to \code{TRUE}.}

\item{sparse}{use a sparse eigendecomposition of the Hessian? Defaults to
\code{FALSE}.}
}
\value{
A list with the following components:
\item{eta}{a matrix of size \code{c(nx, sum(d) + r)} with the
projected gradient evaluated at \code{x}.}
\item{u1}{a matrix of size \code{c(nx, sum(d) + r)} with the
first non-null Hessian eigenvector evaluated at \code{x}.}
\item{lamb_norm}{a matrix of size \code{c(nx, sum(d) + r)} with the
Hessian eigenvalues (largest to smallest) evaluated at \code{x}.}
}
\description{
Computes the projected gradient
\eqn{\mathsf{D}_{(p-1)}\hat{f}(\boldsymbol{x};\boldsymbol{h})} of the
kernel density estimator \eqn{\hat{f}(\boldsymbol{x};\boldsymbol{h})} on the
polysphere \eqn{\mathcal{S}^{d_1} \times \cdots \times \mathcal{S}^{d_r}},
where \eqn{p=\sum_{j=1}^r d_j+r} is the dimension of the ambient space.
}
\examples{
# Simple check on (S^1)^2
n <- 3
d <- c(1, 1)
mu <- c(0, 1, 0, 1)
kappa <- c(5, 5)
h <- c(0.2, 0.2)
X <- r_vmf_polysph(n = n, d = d, mu = mu, kappa = kappa)
proj_grad_kde_polysph(x = X, X = X, d = d, h = h)
}
