% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_degree.R
\name{matrix.degree}
\alias{matrix.degree}
\alias{matrix.degree,matrix-method}
\alias{matrix.degree,polynomial-method}
\alias{matrix.degree,polyMatrix-method}
\title{Degree of each item of matrix}
\usage{
matrix.degree(x)

\S4method{matrix.degree}{matrix}(x)

\S4method{matrix.degree}{polynomial}(x)

\S4method{matrix.degree}{polyMatrix}(x)
}
\arguments{
\item{x}{an \R object}
}
\value{
If the argument is a matrix, the result is a matrix of the same size
containing the degrees of the matrix items.

For a numerical matrix the value is always a zero matrix of the same size

For a polynomial the value is the degree of the polynomial
}
\description{
Returns a matrix obtained by applying a function \code{\link[=degree]{degree()}}
for each element of the matrix.
}
\details{
Degree of each item is calculated using \code{\link[=degree]{degree()}} which is defined for polynomials
as the highest degree of the terms with non-zero coefficient.

For convenience this function is defined for any object,
but returns zero for non polynomial objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{matrix}: the degree of a numerical matrix is a zero matrix for compatibility

\item \code{polynomial}: the degree of a polynomial

\item \code{polyMatrix}: a matrix of degrees for each polynomial item of the source matrix
}}

\examples{

# numerical matrices
matrix.degree(matrix(1:6, 2, 3))
##      [,1] [,2] [,3]
## [1,]    0    0    0
## [2,]    0    0    0

# polynomials
matrix.degree(parse.polynomial("x + 1")) ## 1
matrix.degree(parse.polynomial("x^3 + 1")) ## 3
matrix.degree(parse.polynomial("1")) ## 0

# polynomial matrices
matrix.degree(parse.polyMatrix(
   "x; x^2 + 1",
   "0; 2x"))
##      [,1] [,2]
## [1,]    1    2
## [2,]    0    1
}
