% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_is_zero.R
\name{is.zero}
\alias{is.zero}
\alias{is.zero,polynomial-method}
\alias{is.zero,polyMatrix-method}
\title{Test if something is zero}
\usage{
is.zero(x, eps = ZERO_EPS)

\S4method{is.zero}{polynomial}(x, eps = ZERO_EPS)

\S4method{is.zero}{polyMatrix}(x, eps = ZERO_EPS)
}
\arguments{
\item{x}{The checked object}

\item{eps}{Minimal numerical value which will not treat as zero}
}
\value{
TRUE if the object can be treat as zero
}
\description{
Generic function to check if we can treat on object as being zero.
For matrices the result is a matrix of the same size.
}
\details{
Different type of objects can be treated as a zero in different ways:
\itemize{
\item Numerical types can be compare by absolute value with \code{eps}.
\item Customer types should define an an customer method.
}

By befault eps:\if{html}{\out{<div class="r">}}\preformatted{ZERO_EPS
}\if{html}{\out{</div>}}\preformatted{## [1] 1e-05
}
}
\section{Methods (by class)}{
\itemize{
\item \code{polynomial}: a polynomail can be treated as zero
if all its coefficients can be treated as zero

\item \code{polyMatrix}: for a polunomial matrix every item is checked as polynomial
}}

\examples{

# numericals and matrices
is.zero(0) ## TRUE
is.zero(0.0001, eps=0.01) ## TRUE
is.zero(c(0, 1, 0)) ## TRUE, FALSE, TRUE
is.zero(matrix(c(1, 9, 0, 0), 2, 2))
# FALSE TRUE
# FALSE TRUE


# polynomials
is.zero(parse.polynomial("0.1 - 0.5 x")) ## FALSE
is.zero(parse.polynomial("0.0001 - 0.0005 x + 0.00002 x^2"), eps=0.01) ## TRUE

}
\seealso{
\code{\link[=zero.round]{zero.round()}}
}
