% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight.R
\docType{methods}
\name{highlight}
\alias{highlight}
\alias{highlight,character-method}
\alias{highlight,html-method}
\alias{highlight,kwic-method}
\title{Highlight tokens in text output.}
\usage{
highlight(.Object, ...)

\S4method{highlight}{character}(.Object, highlight = list(),
  regex = FALSE, perl = FALSE, ...)

\S4method{highlight}{html}(.Object, highlight = list(), regex = FALSE,
  perl = FALSE, ...)

\S4method{highlight}{kwic}(.Object, highlight = list(), regex = FALSE,
  perl = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{.Object}{A \code{html}, \code{character}, a \code{kwic} object.}

\item{...}{Terms to be highlighted can be passed in as named character
vectors of terms (or regular expressions); the name then needs to be a
valid color name.}

\item{highlight}{A character vector, or a list of character or integer vectors.}

\item{regex}{Logical, whether character vectors are interpreted as regular
expressions.}

\item{perl}{Logical, whether to use perl-style regular expressions for
highlighting when regex is \code{TRUE}.}

\item{verbose}{Logical, whether to output messages.}
}
\description{
Highlight tokens in fulltext based on exact match, a regular expression or
corpus position in \code{kwic} output or \code{html} document.
}
\details{
If \code{highlight} is a character vector, the names of the vector are
interpreted as colors. If \code{highlight} is a list, the names of the list
are considered as colors. Values can be character values or integer values
with token ids. Colors are inserted into the output html and need to be
digestable for the browser used.
}
\examples{
use("polmineR")
P <- partition("REUTERS", places = "argentina")
H <- html(P)
Y <- highlight(H, list(lightgreen = "higher"))
if (interactive()) htmltools::html_print(Y)

# highlight matches for a CQP query
H2 <- highlight(
  H,
  highlight = list(yellow = cpos(hits(P, query = '"prod.*"', cqp = TRUE)))
)

# the method can be used in pipe
P \%>\% html() \%>\% highlight(list(lightgreen = "1986")) -> H
P \%>\% html() \%>\% highlight(list(lightgreen = c("1986", "higher"))) -> H
P \%>\% html() \%>\% highlight(list(lightgreen = 4020:4023)) -> H

# use highlight for kwic output
K <- kwic("REUTERS", query = "barrel")
K2 <- highlight(K, highlight = list(yellow = c("oil", "price")))

# use character vector for output, not list
K2 <- highlight(
  K,
  highlight = c(
    green = "pric.",
    red = "reduction",
    red = "decrease",
    orange = "dropped"
  ),
  regex = TRUE
)
}
